/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.CompositeModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.color.item.FluidContentsTint;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.ComposedModelState;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class DynamicFluidContainerModel
implements ItemModel {
    private static final Transformation FLUID_TRANSFORM = new Transformation((Vector3fc)new Vector3f(), (Quaternionfc)new Quaternionf(), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.002f), (Quaternionfc)new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation((Vector3fc)new Vector3f(), (Quaternionfc)new Quaternionf(), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.004f), (Quaternionfc)new Quaternionf());
    private static final ModelDebugName DEBUG_NAME = () -> "DynamicFluidContainerModel";
    private static final RenderTypeGroup RENDER_TYPES_DEFAULT = new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, NeoForgeRenderTypes::getUnsortedTranslucent);
    private static final RenderTypeGroup RENDER_TYPES_UNLIT = new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, NeoForgeRenderTypes::getUnlitTranslucent);
    private final Unbaked unbakedModel;
    private final ItemModel.BakingContext bakingContext;
    private final ItemTransforms itemTransforms;
    private final Map<Fluid, ItemModel> cache = new IdentityHashMap<Fluid, ItemModel>();

    private static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return unlit ? RENDER_TYPES_UNLIT : RENDER_TYPES_DEFAULT;
    }

    private DynamicFluidContainerModel(Unbaked unbakedModel, ItemModel.BakingContext bakingContext) {
        this.unbakedModel = unbakedModel;
        this.bakingContext = bakingContext;
        ResolvedModel baseItemModel = bakingContext.blockModelBaker().getModel(Identifier.withDefaultNamespace((String)"item/generated"));
        if (baseItemModel == null) {
            throw new IllegalStateException("Failed to access item/generated model");
        }
        this.itemTransforms = baseItemModel.getTopTransforms();
    }

    private ItemModel bakeModelForFluid(Fluid fluid) {
        List<BakedQuad> quads;
        List<BlockElement> unbaked;
        ComposedModelState transformedState;
        TextureAtlasSprite particleSprite;
        SpriteGetter sprites = this.bakingContext.blockModelBaker().sprites();
        Material particleLocation = this.unbakedModel.textures.particle.map(ClientHooks::getItemMaterial).orElse(null);
        Material baseLocation = this.unbakedModel.textures.base.map(ClientHooks::getItemMaterial).orElse(null);
        Material fluidMaskLocation = this.unbakedModel.textures.fluid.map(ClientHooks::getItemMaterial).orElse(null);
        Material coverLocation = this.unbakedModel.textures.cover.map(ClientHooks::getItemMaterial).orElse(null);
        TextureAtlasSprite baseSprite = baseLocation != null ? sprites.get(baseLocation, DEBUG_NAME) : null;
        TextureAtlasSprite fluidSprite = fluid != Fluids.EMPTY ? sprites.get(ClientHooks.getBlockMaterial(IClientFluidTypeExtensions.of(fluid).getStillTexture()), DEBUG_NAME) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.unbakedModel.coverIsMask || baseLocation != null) ? sprites.get(coverLocation, DEBUG_NAME) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? sprites.get(particleLocation, DEBUG_NAME) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.unbakedModel.coverIsMask) {
            particleSprite = coverSprite;
        }
        Object state = BlockModelRotation.IDENTITY;
        if (this.unbakedModel.flipGas && fluid != Fluids.EMPTY && fluid.getFluidType().isLighterThanAir()) {
            state = new ComposedModelState((ModelState)state, new Transformation(null, (Quaternionfc)new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null));
        }
        ArrayList<BlockModelWrapper> subModels = new ArrayList<BlockModelWrapper>();
        ModelRenderProperties renderProperties = new ModelRenderProperties(false, particleSprite, this.itemTransforms);
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null) {
            List<BlockElement> unbaked2 = UnbakedElementsHelper.createUnbakedItemElements(0, baseSprite);
            List<BakedQuad> quads2 = UnbakedElementsHelper.bakeElements(unbaked2, $ -> baseSprite, (ModelState)state);
            Function<ItemStack, RenderType> renderType = RenderTypeHelper.detectItemModelRenderType(quads2, normalRenderTypes);
            subModels.add(new BlockModelWrapper(List.of(), quads2, renderProperties, renderType));
        }
        if (fluidMaskLocation != null && fluidSprite != null) {
            TextureAtlasSprite templateSprite = sprites.get(fluidMaskLocation, DEBUG_NAME);
            transformedState = new ComposedModelState((ModelState)state, FLUID_TRANSFORM);
            unbaked = UnbakedElementsHelper.createUnbakedItemMaskElements(0, templateSprite);
            quads = UnbakedElementsHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState);
            boolean emissive = this.unbakedModel.applyFluidLuminosity && fluid.getFluidType().getLightLevel() > 0;
            Function<ItemStack, RenderType> renderType = RenderTypeHelper.detectItemModelRenderType(quads, DynamicFluidContainerModel.getLayerRenderTypes(emissive));
            if (emissive) {
                quads = new ArrayList<BakedQuad>(quads);
                quads.replaceAll(DynamicFluidContainerModel::setMaxEmissivity);
            }
            subModels.add(new BlockModelWrapper(List.of(FluidContentsTint.INSTANCE), quads, renderProperties, renderType));
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite = this.unbakedModel.coverIsMask ? baseSprite : coverSprite;
            transformedState = new ComposedModelState((ModelState)state, COVER_TRANSFORM);
            unbaked = UnbakedElementsHelper.createUnbakedItemMaskElements(0, coverSprite);
            quads = UnbakedElementsHelper.bakeElements(unbaked, $ -> sprite, transformedState);
            Function<ItemStack, RenderType> renderType = RenderTypeHelper.detectItemModelRenderType(quads, normalRenderTypes);
            subModels.add(new BlockModelWrapper(List.of(), quads, renderProperties, renderType));
        }
        return new CompositeModel(subModels);
    }

    private static BakedQuad setMaxEmissivity(BakedQuad quad) {
        return new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), quad.packedUV0(), quad.packedUV1(), quad.packedUV2(), quad.packedUV3(), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), 15, quad.bakedNormals(), quad.bakedColors(), quad.hasAmbientOcclusion());
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable ItemOwner owner, int seed) {
        FluidStack fluidStack = FluidUtil.getFirstStackContained(stack);
        Fluid fluid = fluidStack.isEmpty() ? this.unbakedModel.fluid : fluidStack.getFluid();
        this.cache.computeIfAbsent(fluid, this::bakeModelForFluid).update(renderState, stack, modelResolver, displayContext, level, owner, seed);
    }

    public record Unbaked(Textures textures, Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Textures.CODEC.fieldOf("textures").forGetter(Unbaked::textures), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(Unbaked::fluid), (App)Codec.BOOL.optionalFieldOf("flip_gas", (Object)false).forGetter(Unbaked::flipGas), (App)Codec.BOOL.optionalFieldOf("cover_is_mask", (Object)true).forGetter(Unbaked::coverIsMask), (App)Codec.BOOL.optionalFieldOf("apply_fluid_luminosity", (Object)true).forGetter(Unbaked::applyFluidLuminosity)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            return new DynamicFluidContainerModel(this, bakingContext);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
        }
    }

    public record Textures(Optional<Identifier> particle, Optional<Identifier> base, Optional<Identifier> fluid, Optional<Identifier> cover) {
        public static final Codec<Textures> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Identifier.CODEC.optionalFieldOf("particle").forGetter(Textures::particle), (App)Identifier.CODEC.optionalFieldOf("base").forGetter(Textures::base), (App)Identifier.CODEC.optionalFieldOf("fluid").forGetter(Textures::fluid), (App)Identifier.CODEC.optionalFieldOf("cover").forGetter(Textures::cover)).apply((Applicative)instance, Textures::new)).validate(textures -> {
            if (textures.particle.isPresent() || textures.base.isPresent() || textures.fluid.isPresent() || textures.cover.isPresent()) {
                return DataResult.success((Object)textures);
            }
            return DataResult.error(() -> "Dynamic fluid container model requires at least one particle, base, fluid or cover texture.");
        });
    }
}

