/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.blaze3d.validation;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuQuery;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.neoforged.neoforge.client.blaze3d.validation.GpuDeviceUsageValidator;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuTexture;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuTextureView;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationRenderPass;
import org.jspecify.annotations.Nullable;

public class ValidationCommandEncoder
implements CommandEncoder {
    private final CommandEncoder realCommandEncoder;
    private final GpuDeviceUsageValidator validator;

    protected ValidationCommandEncoder(CommandEncoder realCommandEncoder, GpuDeviceUsageValidator validator) {
        this.realCommandEncoder = realCommandEncoder;
        this.validator = validator;
    }

    protected ValidationRenderPass wrapRenderPass(RenderPass renderPass, GpuDeviceUsageValidator validator) {
        return new ValidationRenderPass(renderPass, validator);
    }

    public RenderPass createRenderPass(Supplier<String> label, GpuTextureView colorTextureView, OptionalInt clearColor) {
        if (colorTextureView instanceof ValidationGpuTextureView) {
            ValidationGpuTextureView validationColorTextureView = (ValidationGpuTextureView)colorTextureView;
            colorTextureView = validationColorTextureView.getRealTextureView();
        }
        return this.wrapRenderPass(this.realCommandEncoder.createRenderPass(label, colorTextureView, clearColor), this.validator);
    }

    public RenderPass createRenderPass(Supplier<String> label, GpuTextureView colorTextureView, OptionalInt clearColor, @Nullable GpuTextureView depthTextureView, OptionalDouble clearDepth) {
        if (colorTextureView instanceof ValidationGpuTextureView) {
            ValidationGpuTextureView validationColorTextureView = (ValidationGpuTextureView)colorTextureView;
            colorTextureView = validationColorTextureView.getRealTextureView();
        }
        if (depthTextureView instanceof ValidationGpuTextureView) {
            ValidationGpuTextureView validationDepthTextureView = (ValidationGpuTextureView)depthTextureView;
            depthTextureView = validationDepthTextureView.getRealTextureView();
        }
        return this.wrapRenderPass(this.realCommandEncoder.createRenderPass(label, colorTextureView, clearColor, depthTextureView, clearDepth), this.validator);
    }

    public void clearColorTexture(GpuTexture texture, int clearColor) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.clearColorTexture(validationTexture.getRealTexture(), clearColor);
    }

    public void clearColorAndDepthTextures(GpuTexture colorTexture, int clearColor, GpuTexture depthTexture, double clearDepth) {
        if (!(colorTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationColorTexture = (ValidationGpuTexture)colorTexture;
        if (!(depthTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationDepthTexture = (ValidationGpuTexture)depthTexture;
        this.realCommandEncoder.clearColorAndDepthTextures(validationColorTexture.getRealTexture(), clearColor, validationDepthTexture.getRealTexture(), clearDepth);
    }

    public void clearColorAndDepthTextures(GpuTexture colorTexture, int clearColor, GpuTexture depthTexture, double clearDepth, int scissorX, int scissorY, int scissorWidth, int scissorHeight) {
        if (!(colorTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationColorTexture = (ValidationGpuTexture)colorTexture;
        if (!(depthTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationDepthTexture = (ValidationGpuTexture)depthTexture;
        this.realCommandEncoder.clearColorAndDepthTextures(validationColorTexture.getRealTexture(), clearColor, validationDepthTexture.getRealTexture(), clearDepth, scissorX, scissorY, scissorWidth, scissorHeight);
    }

    public void clearDepthTexture(GpuTexture depthTexture, double clearDepth) {
        if (!(depthTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationDepthTexture = (ValidationGpuTexture)depthTexture;
        this.realCommandEncoder.clearDepthTexture(validationDepthTexture.getRealTexture(), clearDepth);
    }

    public void clearStencilTexture(GpuTexture stencilTexture, int clearValue) {
        if (!(stencilTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationStencilTexture = (ValidationGpuTexture)stencilTexture;
        this.realCommandEncoder.clearStencilTexture(validationStencilTexture.getRealTexture(), clearValue);
    }

    public void writeToBuffer(GpuBufferSlice bufferSlice, ByteBuffer data) {
        this.realCommandEncoder.writeToBuffer(bufferSlice, data);
    }

    public GpuBuffer.MappedView mapBuffer(GpuBuffer buffer, boolean read, boolean write) {
        return this.realCommandEncoder.mapBuffer(buffer, read, write);
    }

    public GpuBuffer.MappedView mapBuffer(GpuBufferSlice bufferSlice, boolean read, boolean write) {
        return this.realCommandEncoder.mapBuffer(bufferSlice, read, write);
    }

    public void copyToBuffer(GpuBufferSlice src, GpuBufferSlice dst) {
        this.realCommandEncoder.copyToBuffer(src, dst);
    }

    public void writeToTexture(GpuTexture texture, NativeImage image) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.writeToTexture(validationTexture.getRealTexture(), image);
    }

    public void writeToTexture(GpuTexture texture, NativeImage image, int mipLevel, int layer, int dstX, int dstY, int width, int height, int srcX, int srcY) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.writeToTexture(validationTexture.getRealTexture(), image, mipLevel, layer, dstX, dstY, width, height, srcX, srcY);
    }

    public void writeToTexture(GpuTexture texture, ByteBuffer imageData, NativeImage.Format imageFormat, int mipLevel, int layer, int x, int y, int width, int height) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.writeToTexture(validationTexture.getRealTexture(), imageData, imageFormat, mipLevel, layer, x, y, width, height);
    }

    public void copyTextureToBuffer(GpuTexture texture, GpuBuffer buffer, long bufferOffset, Runnable callback, int mipLevel) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.copyTextureToBuffer(validationTexture.getRealTexture(), buffer, bufferOffset, callback, mipLevel);
    }

    public void copyTextureToBuffer(GpuTexture texture, GpuBuffer buffer, long bufferOffset, Runnable callback, int mipLevel, int x, int y, int width, int height) {
        if (!(texture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationTexture = (ValidationGpuTexture)texture;
        this.realCommandEncoder.copyTextureToBuffer(validationTexture.getRealTexture(), buffer, bufferOffset, callback, mipLevel, x, y, width, height);
    }

    public void copyTextureToTexture(GpuTexture srcTexture, GpuTexture dstTexture, int mipLevel, int srcX, int srcY, int dstX, int dstY, int width, int height) {
        if (!(srcTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationSrcTexture = (ValidationGpuTexture)srcTexture;
        if (!(dstTexture instanceof ValidationGpuTexture)) {
            throw new IllegalArgumentException();
        }
        ValidationGpuTexture validationDstTexture = (ValidationGpuTexture)dstTexture;
        this.realCommandEncoder.copyTextureToTexture(validationSrcTexture.getRealTexture(), validationDstTexture.getRealTexture(), mipLevel, srcX, srcY, dstX, dstY, width, height);
    }

    public void presentTexture(GpuTextureView textureView) {
        if (textureView instanceof ValidationGpuTextureView) {
            ValidationGpuTextureView validationTextureView = (ValidationGpuTextureView)textureView;
            textureView = validationTextureView.getRealTextureView();
        }
        this.realCommandEncoder.presentTexture(textureView);
    }

    public GpuFence createFence() {
        return this.realCommandEncoder.createFence();
    }

    public GpuQuery timerQueryBegin() {
        return this.realCommandEncoder.timerQueryBegin();
    }

    public void timerQueryEnd(GpuQuery query) {
        this.realCommandEncoder.timerQueryEnd(query);
    }
}

