/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemUtil;

public final class DispenseFluidContainer
extends DefaultDispenseItemBehavior {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        ItemStacksResourceHandler containingHandler = new ItemStacksResourceHandler(2);
        containingHandler.set(0, ItemResource.of(stack), stack.getCount());
        ItemAccess itemAccess = ItemAccess.forHandlerIndex(containingHandler, 0).oneByOne();
        ResourceHandler<FluidResource> resourceHandler = itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (resourceHandler == null) {
            return super.execute(source, stack);
        }
        Direction dispenserFacing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos targetPos = source.pos().relative(dispenserFacing);
        if (!FluidUtil.tryPickupFluid(resourceHandler, null, (Level)source.level(), targetPos, dispenserFacing.getOpposite()).isEmpty() || !FluidUtil.tryPlaceFluid(resourceHandler, null, (Level)source.level(), InteractionHand.MAIN_HAND, targetPos).isEmpty()) {
            ItemStack stack0 = ItemUtil.getStack(containingHandler, 0);
            ItemStack stack1 = ItemUtil.getStack(containingHandler, 1);
            stack0.grow(1);
            return this.consumeWithRemainder(source, stack, stack1);
        }
        return super.execute(source, stack);
    }
}

