/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import org.apache.commons.lang3.tuple.Pair;

public class VillagerTradingManager {
    private static final Map<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>> VANILLA_TRADES = new HashMap<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
    private static final List<Pair<VillagerTrades.ItemListing[], Integer>> WANDERER_TRADES = new ArrayList<Pair<VillagerTrades.ItemListing[], Integer>>();

    static void loadTrades(TagsUpdatedEvent e) {
        if (e.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            VillagerTradingManager.postWandererEvent(e.getLookupProvider());
            VillagerTradingManager.postVillagerEvents(e.getLookupProvider());
        }
    }

    private static void postWandererEvent(HolderLookup.Provider registries) {
        NonNullList buying = NonNullList.create();
        NonNullList rare = NonNullList.create();
        NonNullList generic = NonNullList.create();
        Arrays.stream((VillagerTrades.ItemListing[])WANDERER_TRADES.get(0).getLeft()).forEach(((List)buying)::add);
        Arrays.stream((VillagerTrades.ItemListing[])WANDERER_TRADES.get(1).getLeft()).forEach(((List)rare)::add);
        Arrays.stream((VillagerTrades.ItemListing[])WANDERER_TRADES.get(2).getLeft()).forEach(((List)generic)::add);
        int buyingAmount = (Integer)WANDERER_TRADES.get(0).getRight();
        int rareAmount = (Integer)WANDERER_TRADES.get(1).getRight();
        int genericAmount = (Integer)WANDERER_TRADES.get(2).getRight();
        ArrayList<Pair<List<VillagerTrades.ItemListing>, Integer>> additional = new ArrayList<Pair<List<VillagerTrades.ItemListing>, Integer>>();
        WandererTradesEvent event = new WandererTradesEvent((List<VillagerTrades.ItemListing>)buying, buyingAmount, (List<VillagerTrades.ItemListing>)rare, rareAmount, (List<VillagerTrades.ItemListing>)generic, genericAmount, additional, registries);
        NeoForge.EVENT_BUS.post((Event)event);
        VillagerTrades.WANDERING_TRADER_TRADES = ImmutableList.builder().add((Object)Pair.of((Object)((VillagerTrades.ItemListing[])buying.toArray(VillagerTrades.ItemListing[]::new)), (Object)event.getBuyingAmount())).add((Object)Pair.of((Object)((VillagerTrades.ItemListing[])rare.toArray(VillagerTrades.ItemListing[]::new)), (Object)event.getRareAmount())).add((Object)Pair.of((Object)((VillagerTrades.ItemListing[])generic.toArray(VillagerTrades.ItemListing[]::new)), (Object)event.getGenericAmount())).addAll(additional.stream().map(pair -> Pair.of((Object)((VillagerTrades.ItemListing[])((List)pair.getLeft()).toArray(VillagerTrades.ItemListing[]::new)), (Object)((Integer)pair.getRight()))).toList()).build();
    }

    private static void postVillagerEvents(HolderLookup.Provider registries) {
        for (Map.Entry entry : BuiltInRegistries.VILLAGER_PROFESSION.entrySet()) {
            ResourceKey prof = (ResourceKey)entry.getKey();
            Int2ObjectMap<VillagerTrades.ItemListing[]> trades = VANILLA_TRADES.getOrDefault(prof, (Int2ObjectMap<VillagerTrades.ItemListing[]>)new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                mutableTrades.put(i, (Object)NonNullList.create());
            }
            trades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$8((Int2ObjectMap)mutableTrades, arg_0));
            NeoForge.EVENT_BUS.post((Event)new VillagerTradesEvent((Int2ObjectMap<List<VillagerTrades.ItemListing>>)mutableTrades, (ResourceKey<VillagerProfession>)prof, registries));
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$9((Int2ObjectMap)newTrades, arg_0));
            VillagerTrades.TRADES.put(prof, newTrades);
        }
    }

    private static /* synthetic */ void lambda$postVillagerEvents$9(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new VillagerTrades.ItemListing[0]));
    }

    private static /* synthetic */ void lambda$postVillagerEvents$8(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((VillagerTrades.ItemListing[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$static$0(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        copy.put(ent.getIntKey(), (Object)Arrays.copyOf((VillagerTrades.ItemListing[])ent.getValue(), ((VillagerTrades.ItemListing[])ent.getValue()).length));
    }

    static {
        VillagerTrades.TRADES.entrySet().forEach(e -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            ((Int2ObjectMap)e.getValue()).int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$static$0((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((ResourceKey<VillagerProfession>)((ResourceKey)e.getKey()), (Int2ObjectMap<VillagerTrades.ItemListing[]>)copy);
        });
        VillagerTrades.WANDERING_TRADER_TRADES.forEach(e -> WANDERER_TRADES.add((Pair<VillagerTrades.ItemListing[], Integer>)Pair.of((Object)Arrays.copyOf((VillagerTrades.ItemListing[])e.getLeft(), ((VillagerTrades.ItemListing[])e.getLeft()).length), (Object)((Integer)e.getRight()))));
    }
}

