/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.util.Map;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.model.ExtendedUnbakedGeometry;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;

public class CompositeUnbakedGeometry
implements ExtendedUnbakedGeometry {
    final ImmutableMap<String, Either<Identifier, UnbakedModel>> children;

    public CompositeUnbakedGeometry(ImmutableMap<String, Either<Identifier, UnbakedModel>> children) {
        this.children = children;
    }

    @Override
    public QuadCollection bake(TextureSlots textureSlots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
        Transformation rootTransform = (Transformation)additionalProperties.getOrDefault(NeoForgeModelProperties.TRANSFORM, (Object)Transformation.identity());
        if (!rootTransform.isIdentity()) {
            state = UnbakedElementsHelper.composeRootTransformIntoModelState(state, rootTransform);
        }
        Map partVisibility = (Map)additionalProperties.getOrDefault(NeoForgeModelProperties.PART_VISIBILITY, Map.of());
        QuadCollection.Builder quadBuilder = new QuadCollection.Builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!partVisibility.getOrDefault(name, true).booleanValue()) continue;
            ResolvedModel model = (ResolvedModel)((Either)entry.getValue()).map(arg_0 -> ((ModelBaker)baker).getModel(arg_0), inline -> baker.resolveInlineModel(inline, () -> debugName.debugName() + "_" + (String)entry.getKey()));
            QuadCollection modelGeometry = model.bakeTopGeometry(model.getTopTextureSlots(), baker, state);
            quadBuilder.addAll(modelGeometry);
        }
        return quadBuilder.build();
    }
}

