/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.neoforge.client.gui.PictureInPictureRendererRegistration;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class PictureInPictureRendererPool<T extends PictureInPictureRenderState>
implements AutoCloseable {
    private final PictureInPictureRendererRegistration<T> factory;
    private final MultiBufferSource.BufferSource buffers;
    private Object2ObjectMap<T, PictureInPictureRenderer<T>> renderersLastFrame = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<T, PictureInPictureRenderer<T>> renderersThisFrame = new Object2ObjectOpenHashMap();

    public PictureInPictureRendererPool(PictureInPictureRendererRegistration<T> factory, MultiBufferSource.BufferSource buffers) {
        this.factory = factory;
        this.buffers = buffers;
    }

    public @Nullable PictureInPictureRenderer<T> get(T state, int guiScale, boolean firstPass) {
        PictureInPictureRenderer<T> renderer;
        int width = (state.x1() - state.x0()) * guiScale;
        int height = (state.y1() - state.y0()) * guiScale;
        if (firstPass) {
            PictureInPictureRenderer renderer2 = (PictureInPictureRenderer)this.renderersLastFrame.get(state);
            if (renderer2 != null && renderer2.canBeReusedFor(state, width, height)) {
                this.renderersLastFrame.remove(state);
                this.renderersThisFrame.put(state, (Object)renderer2);
                return renderer2;
            }
            return null;
        }
        ObjectIterator it = this.renderersLastFrame.values().iterator();
        while (it.hasNext()) {
            renderer = (PictureInPictureRenderer<T>)it.next();
            if (!renderer.canBeReusedFor(state, width, height)) continue;
            it.remove();
            this.renderersThisFrame.put(state, renderer);
            return renderer;
        }
        renderer = this.factory.factory().apply(this.buffers);
        this.renderersThisFrame.put(state, renderer);
        return renderer;
    }

    public void clearUnusedRenderers() {
        this.renderersLastFrame.values().forEach(PictureInPictureRenderer::close);
        this.renderersLastFrame.clear();
        Object2ObjectMap<T, PictureInPictureRenderer<T>> tmp = this.renderersLastFrame;
        this.renderersLastFrame = this.renderersThisFrame;
        this.renderersThisFrame = tmp;
    }

    @Override
    public void close() {
        this.renderersThisFrame.values().forEach(PictureInPictureRenderer::close);
        this.renderersLastFrame.values().forEach(PictureInPictureRenderer::close);
    }

    public static Map<Class<? extends PictureInPictureRenderState>, PictureInPictureRendererPool<?>> createPools(MultiBufferSource.BufferSource bufferSource, List<PictureInPictureRendererRegistration<?>> pipRendererFactories) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PictureInPictureRendererRegistration<?> factory : pipRendererFactories) {
            builder.put(factory.stateClass(), new PictureInPictureRendererPool(factory, bufferSource));
        }
        return builder.buildOrThrow();
    }
}

