/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import org.jspecify.annotations.Nullable;

public class CreativeModeTabSearchRegistry {
    private static final Map<CreativeModeTab, SessionSearchTrees.Key> NAME_SEARCH_KEYS = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
    private static final Map<CreativeModeTab, SessionSearchTrees.Key> TAG_SEARCH_KEYS = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
    private static final CompletableFuture<SearchTree<ItemStack>> DEFAULT_SEARCH = CompletableFuture.completedFuture(SearchTree.empty());
    private static final Map<SessionSearchTrees.Key, CompletableFuture<SearchTree<ItemStack>>> NAME_SEARCH_TREES = new IdentityHashMap<SessionSearchTrees.Key, CompletableFuture<SearchTree<ItemStack>>>();
    private static final Map<SessionSearchTrees.Key, CompletableFuture<SearchTree<ItemStack>>> TAG_SEARCH_TREES = new IdentityHashMap<SessionSearchTrees.Key, CompletableFuture<SearchTree<ItemStack>>>();

    public static Map<CreativeModeTab, SessionSearchTrees.Key> getNameSearchKeys() {
        IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key> nameSearchKeys = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
        nameSearchKeys.put(CreativeModeTabs.searchTab(), CreativeModeTabSearchRegistry.getNameSearchKey(CreativeModeTabs.searchTab()));
        for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
            SessionSearchTrees.Key nameSearchKey = CreativeModeTabSearchRegistry.getNameSearchKey(tab);
            if (nameSearchKey == null) continue;
            nameSearchKeys.put(tab, nameSearchKey);
        }
        return nameSearchKeys;
    }

    public static Map<CreativeModeTab, SessionSearchTrees.Key> getTagSearchKeys() {
        IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key> tagSearchKeys = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
        tagSearchKeys.put(CreativeModeTabs.searchTab(), CreativeModeTabSearchRegistry.getTagSearchKey(CreativeModeTabs.searchTab()));
        for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
            SessionSearchTrees.Key tagSearchKey = CreativeModeTabSearchRegistry.getTagSearchKey(tab);
            if (tagSearchKey == null) continue;
            tagSearchKeys.put(tab, tagSearchKey);
        }
        return tagSearchKeys;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SessionSearchTrees.Key getNameSearchKey(CreativeModeTab tab) {
        if (tab == CreativeModeTabs.searchTab()) {
            return SessionSearchTrees.CREATIVE_NAMES;
        }
        if (!tab.hasSearchBar()) {
            return null;
        }
        return NAME_SEARCH_KEYS.computeIfAbsent(tab, k -> new SessionSearchTrees.Key());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SessionSearchTrees.Key getTagSearchKey(CreativeModeTab tab) {
        if (tab == CreativeModeTabs.searchTab()) {
            return SessionSearchTrees.CREATIVE_TAGS;
        }
        if (!tab.hasSearchBar()) {
            return null;
        }
        return TAG_SEARCH_KEYS.computeIfAbsent(tab, k -> new SessionSearchTrees.Key());
    }

    public static CompletableFuture<SearchTree<ItemStack>> getNameSearchTree(SessionSearchTrees.Key key) {
        return NAME_SEARCH_TREES.getOrDefault(key, DEFAULT_SEARCH);
    }

    public static void putNameSearchTree(SessionSearchTrees.Key key, CompletableFuture<SearchTree<ItemStack>> future) {
        NAME_SEARCH_TREES.put(key, future);
    }

    public static CompletableFuture<SearchTree<ItemStack>> getTagSearchTree(SessionSearchTrees.Key key) {
        return TAG_SEARCH_TREES.getOrDefault(key, DEFAULT_SEARCH);
    }

    public static void putTagSearchTree(SessionSearchTrees.Key key, CompletableFuture<SearchTree<ItemStack>> future) {
        TAG_SEARCH_TREES.put(key, future);
    }
}

