/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.server.command.CommandUtils;
import net.neoforged.neoforge.server.command.generation.GenerationBar;
import net.neoforged.neoforge.server.command.generation.GenerationTask;

class GenerateCommand {
    private static GenerationTask activeTask;
    private static GenerationBar generationBar;

    GenerateCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"generate").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_OWNERS));
        builder.then(Commands.literal((String)"start").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"chunkRadius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2500)).then(Commands.argument((String)"progressBar", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> GenerateCommand.executeGeneration((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "chunkRadius"), GenerateCommand.getBool((CommandContext<CommandSourceStack>)ctx, "progressBar"))))).executes(ctx -> GenerateCommand.executeGeneration((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "chunkRadius"), true)))));
        builder.then(Commands.literal((String)"stop").executes(ctx -> GenerateCommand.stopGeneration((CommandSourceStack)ctx.getSource())));
        builder.then(Commands.literal((String)"status").executes(ctx -> GenerateCommand.getGenerationStatus((CommandSourceStack)ctx.getSource())));
        builder.then(Commands.literal((String)"help").executes(ctx -> GenerateCommand.getGenerationHelp((CommandSourceStack)ctx.getSource())));
        return builder;
    }

    private static int getInt(CommandContext<CommandSourceStack> ctx, String name) {
        return IntegerArgumentType.getInteger(ctx, (String)name);
    }

    private static boolean getBool(CommandContext<CommandSourceStack> ctx, String name) {
        return BoolArgumentType.getBool(ctx, (String)name);
    }

    private static int executeGeneration(CommandSourceStack source, BlockPos pos, int chunkRadius, boolean progressBar) {
        if (activeTask != null) {
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.already_running"), true);
            return 1;
        }
        ChunkPos origin = new ChunkPos(pos);
        activeTask = new GenerationTask(source.getLevel(), origin.x, origin.z, chunkRadius);
        int diameter = chunkRadius * 2 + 1;
        if (progressBar) {
            generationBar = new GenerationBar();
            if (source.getEntity() instanceof ServerPlayer) {
                generationBar.addPlayer(source.getPlayer());
            }
        }
        source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.started", activeTask.getTotalCount(), diameter, diameter, diameter * 16, diameter * 16), true);
        activeTask.run(GenerateCommand.createPregenListener(source));
        return 1;
    }

    private static int stopGeneration(CommandSourceStack source) {
        if (activeTask != null) {
            activeTask.stop();
            int count = activeTask.getOkCount() + activeTask.getErrorCount() + activeTask.getSkippedCount();
            int total = activeTask.getTotalCount();
            double percent = (double)count / (double)total * 100.0;
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.stopped", count, total, percent), true);
            if (generationBar != null) {
                generationBar.close();
                generationBar = null;
            }
            activeTask = null;
        } else {
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.not_running"), false);
        }
        return 1;
    }

    private static int getGenerationStatus(CommandSourceStack source) {
        if (activeTask != null) {
            int count = activeTask.getOkCount() + activeTask.getErrorCount() + activeTask.getSkippedCount();
            int total = activeTask.getTotalCount();
            double percent = (double)count / (double)total * 100.0;
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.status", count, total, percent), true);
        } else {
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.not_running"), false);
        }
        return 1;
    }

    private static int getGenerationHelp(CommandSourceStack source) {
        source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.help_line"), false);
        return 1;
    }

    private static GenerationTask.Listener createPregenListener(final CommandSourceStack source) {
        return new GenerationTask.Listener(){

            @Override
            public void update(int ok, int error, int skipped, int total) {
                if (generationBar != null) {
                    generationBar.update(ok, error, skipped, total);
                }
            }

            @Override
            public void complete(int error) {
                source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.success"), true);
                if (error > 0) {
                    source.sendFailure((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.chunkgen.error"));
                }
                if (generationBar != null) {
                    generationBar.close();
                    generationBar = null;
                }
                activeTask = null;
            }
        };
    }
}

