/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.configuration;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.Identifier;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.FeatureFlagAcknowledgePayload;
import net.neoforged.neoforge.network.payload.FeatureFlagDataPayload;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public record CheckFeatureFlags(ServerConfigurationPacketListener listener) implements ConfigurationTask
{
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"check_feature_flags"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Set<Identifier> moddedFlags = null;

    public void start(Consumer<Packet<?>> packetSender) {
        if (this.listener.getConnection().isMemoryConnection()) {
            this.listener.finishCurrentTask(TYPE);
            return;
        }
        Set<Identifier> moddedFlags = CheckFeatureFlags.getModdedFeatureFlags();
        if (this.listener.getConnectionType().isOther() || !this.listener.hasChannel(FeatureFlagDataPayload.TYPE)) {
            if (!moddedFlags.isEmpty()) {
                this.listener.disconnect((Component)Component.literal((String)"This server does not support vanilla clients as it has custom FeatureFlags"));
            } else {
                this.listener.finishCurrentTask(TYPE);
            }
            return;
        }
        packetSender.accept((Packet<?>)new FeatureFlagDataPayload(moddedFlags).toVanillaClientbound());
    }

    public static void handleClientboundPayload(FeatureFlagDataPayload payload, IPayloadContext context) {
        Set<Identifier> remoteFlags;
        Set<Identifier> localFlags = CheckFeatureFlags.getModdedFeatureFlags();
        if (localFlags.equals(remoteFlags = payload.moddedFlags())) {
            context.reply(FeatureFlagAcknowledgePayload.INSTANCE);
        } else {
            Sets.SetView missingRemote;
            context.disconnect((Component)Component.translatable((String)"neoforge.network.feature_flags.entry_mismatch"));
            StringBuilder message = new StringBuilder("The server and client have different sets of custom FeatureFlags");
            Sets.SetView missingLocal = Sets.difference(remoteFlags, localFlags);
            if (!missingLocal.isEmpty()) {
                message.append("\n\tFlags missing on the client, but present on the server:");
                for (Identifier flag : missingLocal) {
                    message.append("\n\t\t- ").append(flag);
                }
            }
            if (!(missingRemote = Sets.difference(localFlags, remoteFlags)).isEmpty()) {
                message.append("\n\tFlags missing on the server, but present on the client:");
                for (Identifier flag : missingRemote) {
                    message.append("\n\t\t- ").append(flag);
                }
            }
            LOGGER.warn(message.toString());
        }
    }

    public static void handleServerboundPayload(FeatureFlagAcknowledgePayload payload, IPayloadContext context) {
        context.finishCurrentTask(TYPE);
    }

    public static boolean handleVanillaServerConnection(ClientConfigurationPacketListener listener) {
        if (!CheckFeatureFlags.getModdedFeatureFlags().isEmpty()) {
            listener.disconnect((Component)Component.translatable((String)"neoforge.network.feature_flags.no_vanilla_server"));
            return false;
        }
        return true;
    }

    private static Set<Identifier> getModdedFeatureFlags() {
        if (moddedFlags == null) {
            moddedFlags = FeatureFlags.REGISTRY.getAllFlags().entrySet().stream().filter(e -> ((FeatureFlag)e.getValue()).isModded()).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        return moddedFlags;
    }

    public ConfigurationTask.Type type() {
        return TYPE;
    }
}

