/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.google.common.math.Stats;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.TickRateManager;
import net.neoforged.neoforge.server.command.CommandUtils;
import org.joml.Math;
import org.jspecify.annotations.Nullable;

class TPSCommand {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");
    private static final long[] UNLOADED = new long[]{0L};

    TPSCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"tps").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> TPSCommand.sendTime((CommandContext<CommandSourceStack>)ctx, DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"))))).executes(ctx -> {
            for (ServerLevel dimension : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                TPSCommand.sendTime((CommandContext<CommandSourceStack>)ctx, dimension);
            }
            TPSCommand.sendTime((CommandContext<CommandSourceStack>)ctx, null);
            return 1;
        });
    }

    private static int sendTime(CommandContext<CommandSourceStack> context, @Nullable ServerLevel dimension) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        src.sendSuccess(() -> TPSCommand.createComponent(src.getServer(), dimension), false);
        return 1;
    }

    private static Component createComponent(MinecraftServer server, @Nullable ServerLevel dimension) {
        MutableComponent component;
        ServerTickRateManager tickRateManager;
        long[] times;
        if (dimension == null) {
            times = server.getTickTimesNanos();
            tickRateManager = server.tickRateManager();
        } else {
            long[] dimensionTimes = server.getTickTime(dimension.dimension());
            times = dimensionTimes == null ? UNLOADED : dimensionTimes;
            tickRateManager = dimension.tickRateManager();
        }
        double tickTime = Stats.meanOf((long[])times) / (double)TimeUtil.NANOSECONDS_PER_MILLISECOND;
        double tps = (double)TimeUtil.MILLISECONDS_PER_SECOND / Math.max((double)tickTime, (double)tickRateManager.millisecondsPerTick());
        MutableComponent tickTimeComponent = Component.literal((String)TIME_FORMATTER.format(tickTime)).withColor(-6250336);
        MutableComponent tpsComponent = Component.literal((String)TIME_FORMATTER.format(tps)).withColor(TPSCommand.calculateTPSColor((TickRateManager)tickRateManager, tps));
        if (dimension == null) {
            component = CommandUtils.makeTranslatableWithFallback("commands.neoforge.tps.overall", tpsComponent, tickTimeComponent);
        } else {
            Holder dimensionType = dimension.dimensionTypeRegistration();
            MutableComponent dimensionName = Component.empty().append(dimension.getDescription()).withStyle(style -> style.withColor(ChatFormatting.GREEN).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.tps.dimension.tooltip", dimension.dimension().identifier().toString(), dimensionType.getRegisteredName()))));
            component = CommandUtils.makeTranslatableWithFallback("commands.neoforge.tps.dimension", dimensionName, tpsComponent, tickTimeComponent);
        }
        return component.withStyle(arg_0 -> TPSCommand.lambda$createComponent$4((TickRateManager)tickRateManager, arg_0));
    }

    private static int calculateTPSColor(TickRateManager tickRateManager, double tps) {
        float maxTPS = (float)TimeUtil.MILLISECONDS_PER_SECOND / tickRateManager.millisecondsPerTick();
        return Mth.hsvToRgb((float)((float)(Mth.inverseLerp((double)tps, (double)0.0, (double)maxTPS) * (double)0.33f)), (float)1.0f, (float)1.0f);
    }

    private static /* synthetic */ Style lambda$createComponent$4(TickRateManager tickRateManager, Style style) {
        return style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.tps.tooltip", Float.valueOf(tickRateManager.tickrate()))));
    }
}

