/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui.widget;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.resources.Identifier;

public abstract class ScrollPanel
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    private final Minecraft client;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    private boolean scrolling;
    protected float scrollDistance;
    protected boolean captureMouse = true;
    protected final int border;
    private final int barWidth;
    private final int barLeft;
    private final int barBgColor;
    private final int barColor;
    private final int barBorderColor;

    public ScrollPanel(Minecraft client, int width, int height, int top, int left) {
        this(client, width, height, top, left, 4);
    }

    public ScrollPanel(Minecraft client, int width, int height, int top, int left, int border) {
        this(client, width, height, top, left, border, 6);
    }

    public ScrollPanel(Minecraft client, int width, int height, int top, int left, int border, int barWidth) {
        this(client, width, height, top, left, border, barWidth, -16777216, -8355712, -4144960);
    }

    public ScrollPanel(Minecraft client, int width, int height, int top, int left, int border, int barWidth, int barBgColor, int barColor, int barBorderColor) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - barWidth;
        this.border = border;
        this.barWidth = barWidth;
        this.barBgColor = barBgColor;
        this.barColor = barColor;
        this.barBorderColor = barBorderColor;
    }

    protected abstract int getContentHeight();

    protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
        Screen.renderMenuBackgroundTexture((GuiGraphics)guiGraphics, (Identifier)Screen.MENU_BACKGROUND, (int)this.left, (int)this.top, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height);
    }

    protected abstract void drawPanel(GuiGraphics var1, int var2, int var3, int var4, int var5);

    protected boolean clickPanel(double mouseX, double mouseY, MouseButtonEvent event) {
        return false;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    private void applyScrollLimits() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max = 0;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double p_294830_) {
        if (p_294830_ != 0.0) {
            this.scrollDistance += (float)(-p_294830_ * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX < (double)this.right && mouseY >= (double)this.top && mouseY < (double)this.bottom;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (super.mouseClicked(event, doubleClick)) {
            return true;
        }
        boolean bl = this.scrolling = event.button() == 0 && event.x() >= (double)this.barLeft && event.x() < (double)this.right && event.y() >= (double)this.top && event.y() < (double)this.bottom;
        if (this.scrolling) {
            return true;
        }
        int mouseListY = (int)event.y() - this.top - this.getContentHeight() + (int)this.scrollDistance - this.border;
        if (event.x() >= (double)this.left && event.x() < (double)this.right && mouseListY < 0) {
            return this.clickPanel(event.x() - (double)this.left, event.y() - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, event);
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (super.mouseReleased(event)) {
            return true;
        }
        boolean ret = this.scrolling;
        this.scrolling = false;
        return ret;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - this.border * 2) {
            barHeight = this.height - this.border * 2;
        }
        return barHeight;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.enableScissor(this.left, this.top, this.right, this.bottom);
        this.drawBackground(guiGraphics, partialTick);
        int baseY = this.top + this.border - (int)this.scrollDistance;
        this.drawPanel(guiGraphics, this.right, baseY, mouseX, mouseY);
        int extraHeight = this.getContentHeight() + this.border - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            guiGraphics.fill(this.barLeft, this.top, this.barLeft + this.barWidth, this.bottom, this.barBgColor);
            guiGraphics.fill(this.barLeft, barTop, this.barLeft + this.barWidth, barTop + barHeight, this.barColor);
            guiGraphics.fill(this.barLeft, barTop, this.barLeft + this.barWidth - 1, barTop + barHeight - 1, this.barBorderColor);
        }
        guiGraphics.disableScissor();
    }

    protected void drawGradientRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color1, int color2) {
        guiGraphics.fillGradient(left, top, right, bottom, color1, color2);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

