/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import org.jspecify.annotations.Nullable;

public interface MutableDataComponentHolder
extends DataComponentHolder {
    public <T> @Nullable T set(DataComponentType<T> var1, @Nullable T var2);

    default public <T> @Nullable T set(Supplier<? extends DataComponentType<T>> componentType, @Nullable T value) {
        return this.set(componentType.get(), value);
    }

    default public <T> void copyFrom(DataComponentType<T> type, DataComponentGetter getter) {
        this.set(type, getter.get(type));
    }

    default public <T> void copyFrom(Supplier<? extends DataComponentType<T>> type, DataComponentGetter getter) {
        this.copyFrom(type.get(), getter);
    }

    default public <T, U> @Nullable T update(DataComponentType<T> componentType, T value, U updateContext, BiFunction<T, U, T> updater) {
        return this.set(componentType, updater.apply(this.getOrDefault(componentType, value), updateContext));
    }

    default public <T, U> @Nullable T update(Supplier<? extends DataComponentType<T>> componentType, T value, U updateContext, BiFunction<T, U, T> updater) {
        return this.update(componentType.get(), value, updateContext, updater);
    }

    default public <T> @Nullable T update(DataComponentType<T> componentType, T value, UnaryOperator<T> updater) {
        return this.set(componentType, updater.apply(this.getOrDefault(componentType, value)));
    }

    default public <T> @Nullable T update(Supplier<? extends DataComponentType<T>> componentType, T value, UnaryOperator<T> updater) {
        return this.update(componentType.get(), value, updater);
    }

    public <T> @Nullable T remove(DataComponentType<? extends T> var1);

    default public <T> @Nullable T remove(Supplier<? extends DataComponentType<? extends T>> componentType) {
        return this.remove(componentType.get());
    }

    default public void copyFrom(DataComponentHolder src, DataComponentType<?> ... componentTypes) {
        for (DataComponentType<?> componentType : componentTypes) {
            this.copyFrom(componentType, src);
        }
    }

    default public void copyFrom(DataComponentHolder src, Supplier<? extends DataComponentType<?>> ... componentTypes) {
        for (Supplier<DataComponentType<?>> supplier : componentTypes) {
            this.copyFrom(supplier.get(), src);
        }
    }

    public void applyComponents(DataComponentPatch var1);

    public void applyComponents(DataComponentMap var1);

    private <T> void copyFrom(DataComponentType<T> componentType, DataComponentHolder src) {
        this.set(componentType, src.get(componentType));
    }
}

