/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.GsonHelper;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class UnbakedModelParser {
    private static ImmutableMap<Identifier, UnbakedModelLoader<?>> LOADERS;

    public static @Nullable UnbakedModelLoader<?> get(Identifier name) {
        return (UnbakedModelLoader)LOADERS.get((Object)name);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap loaders = new HashMap();
        ModLoader.postEventWrapContainerInModOrder((Event)new ModelEvent.RegisterLoaders(loaders));
        LOADERS = ImmutableMap.copyOf(loaders);
    }

    public static UnbakedModel parse(Reader reader) {
        return (UnbakedModel)GsonHelper.fromJson((Gson)BlockModel.GSON, (Reader)reader, UnbakedModel.class);
    }

    @ApiStatus.Internal
    public static final class Deserializer
    implements JsonDeserializer<UnbakedModel> {
        public UnbakedModel deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Expected object, got " + String.valueOf(jsonElement));
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("loader")) {
                boolean optional;
                Identifier loader;
                if (jsonObject.get("loader").isJsonObject()) {
                    JsonObject loaderObject = jsonObject.getAsJsonObject("loader");
                    loader = Identifier.parse((String)GsonHelper.getAsString((JsonObject)loaderObject, (String)"id"));
                    optional = GsonHelper.getAsBoolean((JsonObject)loaderObject, (String)"optional", (boolean)false);
                } else {
                    loader = Identifier.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"loader"));
                    optional = false;
                }
                UnbakedModelLoader<?> loaderInstance = UnbakedModelParser.get(loader);
                if (loaderInstance != null) {
                    return loaderInstance.read(jsonObject, jsonDeserializationContext);
                }
                if (!optional) {
                    throw new JsonParseException("Unknown loader: " + String.valueOf(loader) + " (did you forget to register it?) Available loaders: " + LOADERS.keySet().stream().map(Identifier::toString).collect(Collectors.joining(", ")));
                }
            }
            return (UnbakedModel)jsonDeserializationContext.deserialize((JsonElement)jsonObject, BlockModel.class);
        }
    }
}

