/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.TransactionalRandom;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class ComposterWrapper
extends SnapshotJournal<BlockState> {
    private static final Map<WrapperLocation, ComposterWrapper> wrappers = new MapMaker().concurrencyLevel(1).weakKeys().weakValues().makeMap();
    private static final ItemResource BONE_MEAL = ItemResource.of((ItemLike)Items.BONE_MEAL);
    private final WrapperLocation location;
    private final TransactionalRandom transactionalRandom = new TransactionalRandom();
    private final ResourceHandler<ItemResource> topHandler = new Top();
    private final ResourceHandler<ItemResource> bottomHandler = new Bottom();

    public static @Nullable ResourceHandler<ItemResource> get(Level level, BlockPos pos, @Nullable Direction direction) {
        if (direction == null || !direction.getAxis().isVertical()) {
            return null;
        }
        WrapperLocation location = new WrapperLocation(level, pos.immutable());
        ComposterWrapper wrapper = wrappers.computeIfAbsent(location, ComposterWrapper::new);
        return direction == Direction.UP ? wrapper.topHandler : wrapper.bottomHandler;
    }

    private ComposterWrapper(WrapperLocation location) {
        this.location = location;
    }

    @Override
    protected BlockState createSnapshot() {
        return this.location.getBlockState();
    }

    @Override
    protected void revertToSnapshot(BlockState snapshot) {
        this.location.level.setBlock(this.location.pos, snapshot, 0);
    }

    @Override
    protected void onRootCommit(BlockState originalState) {
        BlockState currentState = this.location.getBlockState();
        if (!currentState.is(Blocks.COMPOSTER)) {
            return;
        }
        if (originalState != currentState) {
            this.location.level.setBlock(this.location.pos, originalState, 0);
            this.location.level.setBlockAndUpdate(this.location.pos, currentState);
            this.location.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.location.pos, GameEvent.Context.of((BlockState)currentState));
        }
        int originalLevel = (Integer)originalState.getValue((Property)ComposterBlock.LEVEL);
        int currentLevel = (Integer)currentState.getValue((Property)ComposterBlock.LEVEL);
        if (originalLevel < 7) {
            if (currentLevel == 7) {
                this.location.level.scheduleTick(this.location.pos, currentState.getBlock(), 20);
            }
            this.location.level.levelEvent(1500, this.location.pos, currentLevel > originalLevel ? 1 : 0);
        }
    }

    private static float getComposterValue(ItemResource resource) {
        return ComposterBlock.getValue((ItemStack)resource.toStack());
    }

    private void setLevel(BlockState state, int newLevel) {
        BlockState newState = (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(newLevel));
        this.location.level.setBlock(this.location.pos, newState, 0);
    }

    private record WrapperLocation(Level level, BlockPos pos) {
        public BlockState getBlockState() {
            return this.level.getBlockState(this.pos);
        }
    }

    private class Top
    implements ResourceHandler<ItemResource> {
        private Top() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            Objects.checkIndex(index, this.size());
            TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
            if (amount < 1) {
                return 0;
            }
            BlockState state = ComposterWrapper.this.location.getBlockState();
            int currentLevel = (Integer)state.getValue((Property)ComposterBlock.LEVEL);
            if (currentLevel >= 7) {
                return 0;
            }
            float value = ComposterWrapper.getComposterValue(resource);
            if (value <= 0.0f) {
                return 0;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            if (currentLevel == 0 || ComposterWrapper.this.transactionalRandom.nextDouble(transaction) < (double)value) {
                ComposterWrapper.this.setLevel(state, currentLevel + 1);
            }
            return 1;
        }

        @Override
        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        @Override
        public ItemResource getResource(int index) {
            return ItemResource.EMPTY;
        }

        @Override
        public long getAmountAsLong(int index) {
            return 0L;
        }

        @Override
        public long getCapacityAsLong(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return resource.isEmpty() || ComposterWrapper.getComposterValue(resource) > 0.0f ? 1L : 0L;
        }

        @Override
        public boolean isValid(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return ComposterWrapper.getComposterValue(resource) > 0.0f;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/top]";
        }
    }

    private class Bottom
    implements ResourceHandler<ItemResource> {
        private Bottom() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        @Override
        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            Objects.checkIndex(index, this.size());
            TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
            if (amount < 1) {
                return 0;
            }
            if (!BONE_MEAL.equals(resource)) {
                return 0;
            }
            BlockState state = ComposterWrapper.this.location.getBlockState();
            if ((Integer)state.getValue((Property)ComposterBlock.LEVEL) != 8) {
                return 0;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.setLevel(state, 0);
            return 1;
        }

        @Override
        public ItemResource getResource(int index) {
            Objects.checkIndex(index, this.size());
            return (Integer)ComposterWrapper.this.location.getBlockState().getValue((Property)ComposterBlock.LEVEL) == 8 ? BONE_MEAL : ItemResource.EMPTY;
        }

        @Override
        public long getAmountAsLong(int index) {
            return this.getResource(index).equals(BONE_MEAL) ? 1L : 0L;
        }

        @Override
        public long getCapacityAsLong(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return resource.isEmpty() || BONE_MEAL.equals(resource) ? 1L : 0L;
        }

        @Override
        public boolean isValid(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return BONE_MEAL.equals(resource);
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/bottom]";
        }
    }
}

