/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.entity.living;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jspecify.annotations.Nullable;

public class BabyEntitySpawnEvent
extends Event
implements ICancellableEvent {
    private final Mob parentA;
    private final Mob parentB;
    private final Player causedByPlayer;
    private AgeableMob child;

    public BabyEntitySpawnEvent(Mob parentA, Mob parentB, @Nullable AgeableMob proposedChild) {
        ServerPlayer causedByPlayer = null;
        if (parentA instanceof Animal) {
            causedByPlayer = ((Animal)parentA).getLoveCause();
        }
        if (causedByPlayer == null && parentB instanceof Animal) {
            causedByPlayer = ((Animal)parentB).getLoveCause();
        }
        this.parentA = parentA;
        this.parentB = parentB;
        this.causedByPlayer = causedByPlayer;
        this.child = proposedChild;
    }

    public Mob getParentA() {
        return this.parentA;
    }

    public Mob getParentB() {
        return this.parentB;
    }

    public @Nullable Player getCausedByPlayer() {
        return this.causedByPlayer;
    }

    public @Nullable AgeableMob getChild() {
        return this.child;
    }

    public void setChild(AgeableMob proposedChild) {
        this.child = proposedChild;
    }
}

