/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jspecify.annotations.Nullable;

public class BlockTagIngredient
implements ICustomIngredient {
    public static final MapCodec<BlockTagIngredient> CODEC = TagKey.codec((ResourceKey)Registries.BLOCK).xmap(BlockTagIngredient::new, BlockTagIngredient::getTag).fieldOf("tag");
    protected final TagKey<Block> tag;
    protected @Nullable HolderSet<Item> items;

    public BlockTagIngredient(TagKey<Block> tag) {
        this.tag = tag;
    }

    protected HolderSet<Item> dissolve() {
        if (this.items == null) {
            ArrayList<Holder.Reference> list = new ArrayList<Holder.Reference>();
            for (Holder block : BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag)) {
                Item item = ((Block)block.value()).asItem();
                if (item == Items.AIR) continue;
                list.add(item.builtInRegistryHolder());
            }
            this.items = HolderSet.direct(list);
        }
        return this.items;
    }

    @Override
    public Stream<Holder<Item>> items() {
        return this.dissolve().stream();
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.dissolve().contains(stack.getItemHolder());
    }

    public TagKey<Block> getTag() {
        return this.tag;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IngredientType<?> getType() {
        return NeoForgeMod.BLOCK_TAG_INGREDIENT.get();
    }

    @Override
    public SlotDisplay display() {
        return new SlotDisplay.Composite(this.dissolve().stream().map(Ingredient::displayForSingleItem).toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockTagIngredient)) {
            return false;
        }
        BlockTagIngredient that = (BlockTagIngredient)o;
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        return this.tag.hashCode();
    }
}

