/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtilities {
    private static final String TEMP_FILE_SUFFIX = ".neoforge-tmp";
    private static final OpenOption[] OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtilities.class);

    private IOUtilities() {
    }

    public static void tryCleanupTempFiles(Path targetPath, @Nullable String prefix) {
        for (Path file : IOUtilities.tryListTempFiles(targetPath, prefix)) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete temp file {}: {}", (Object)file, (Object)e.toString());
            }
        }
    }

    private static List<Path> tryListTempFiles(Path targetPath, @Nullable String prefix) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.find(targetPath, 1, IOUtilities.createPredicate(prefix), new FileVisitOption[0]);
            try {
                list = stream.toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to list temporary files in {}", (Object)targetPath, (Object)e);
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    private static BiPredicate<Path, BasicFileAttributes> createPredicate(@Nullable String prefix) {
        return (file, attributes) -> {
            String fileName = file.getFileName().toString();
            return fileName.endsWith(TEMP_FILE_SUFFIX) && (prefix == null || fileName.startsWith(prefix));
        };
    }

    public static void writeNbtCompressed(CompoundTag tag, Path path) throws IOException {
        IOUtilities.atomicWrite(path, stream -> {
            try (BufferedOutputStream bufferedStream = new BufferedOutputStream(stream);){
                NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)bufferedStream);
            }
        });
    }

    public static void writeNbt(CompoundTag tag, Path path) throws IOException {
        IOUtilities.atomicWrite(path, stream -> {
            try (BufferedOutputStream bufferedStream = new BufferedOutputStream(stream);
                 DataOutputStream dataStream = new DataOutputStream(bufferedStream);){
                NbtIo.write((CompoundTag)tag, (DataOutput)dataStream);
            }
        });
    }

    public static void atomicWrite(Path targetPath, WriteCallback writeCallback) throws IOException {
        Path tempPath = Files.createTempFile(targetPath.getParent(), targetPath.getFileName().toString(), TEMP_FILE_SUFFIX, new FileAttribute[0]);
        try {
            try (FileChannel channel = FileChannel.open(tempPath, OPEN_OPTIONS);){
                CloseShieldOutputStream stream = CloseShieldOutputStream.wrap((OutputStream)Channels.newOutputStream(channel));
                writeCallback.write((OutputStream)stream);
                channel.force(true);
            }
            try {
                Files.move(tempPath, targetPath, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception first) {
            try {
                Files.deleteIfExists(tempPath);
            }
            catch (Exception second) {
                first.addSuppressed(second);
            }
            throw first;
        }
    }

    public static interface WriteCallback {
        public void write(OutputStream var1) throws IOException;
    }
}

