/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class ChannelAttributes {
    public static final AttributeKey<NetworkPayloadSetup> PAYLOAD_SETUP = AttributeKey.valueOf((String)"neoforge:payload_setup");
    public static final AttributeKey<Set<Identifier>> ADHOC_CHANNELS = AttributeKey.valueOf((String)"neoforge:adhoc_channels");
    public static final AttributeKey<Map<ConnectionProtocol, Set<Identifier>>> COMMON_CHANNELS = AttributeKey.valueOf((String)"neoforge:common_channels");
    public static final AttributeKey<ConnectionType> CONNECTION_TYPE = AttributeKey.valueOf((String)"neoforge:connection_type");

    public static @Nullable NetworkPayloadSetup getPayloadSetup(Connection connection) {
        return (NetworkPayloadSetup)connection.channel().attr(PAYLOAD_SETUP).get();
    }

    public static void setPayloadSetup(Connection connection, NetworkPayloadSetup setup) {
        connection.channel().attr(PAYLOAD_SETUP).set((Object)setup);
    }

    public static @Nullable ConnectionType getConnectionType(Connection connection) {
        return (ConnectionType)((Object)connection.channel().attr(CONNECTION_TYPE).get());
    }

    public static void setConnectionType(Connection connection, ConnectionType type) {
        connection.channel().attr(CONNECTION_TYPE).set((Object)type);
    }

    public static Set<Identifier> getOrCreateAdHocChannels(Connection connection) {
        HashSet channels = (HashSet)connection.channel().attr(ADHOC_CHANNELS).get();
        if (channels == null) {
            channels = new HashSet();
            connection.channel().attr(ADHOC_CHANNELS).set(channels);
        }
        return channels;
    }

    public static Set<Identifier> getOrCreateCommonChannels(Connection connection, ConnectionProtocol protocol) {
        EnumMap<ConnectionProtocol, Set> channels = (EnumMap<ConnectionProtocol, Set>)connection.channel().attr(COMMON_CHANNELS).get();
        if (channels == null) {
            channels = new EnumMap<ConnectionProtocol, Set>(ConnectionProtocol.class);
            connection.channel().attr(COMMON_CHANNELS).set(channels);
        }
        return channels.computeIfAbsent(protocol, p -> new HashSet());
    }
}

