/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.network.handling;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ClientPayloadContext
extends Record
implements IPayloadContext {
    private final ClientCommonPacketListener listener;
    private final Identifier payloadId;

    public ClientPayloadContext(ClientCommonPacketListener listener, Identifier payloadId) {
        this.listener = listener;
        this.payloadId = payloadId;
    }

    @Override
    public void handle(CustomPacketPayload payload) {
        this.handle((Packet<?>)new ClientboundCustomPayloadPacket(payload));
    }

    @Override
    public CompletableFuture<Void> enqueueWork(Runnable task) {
        PacketProcessor processor = this.listener.getPacketProcessor();
        if (processor.isSameThread()) {
            task.run();
            return CompletableFuture.completedFuture(null);
        }
        return NetworkRegistry.guard(CompletableFuture.runAsync(task, arg_0 -> ((PacketProcessor)processor).scheduleIfPossible(arg_0)), this.payloadId);
    }

    @Override
    public <T> CompletableFuture<T> enqueueWork(Supplier<T> task) {
        PacketProcessor processor = this.listener.getPacketProcessor();
        if (processor.isSameThread()) {
            return CompletableFuture.completedFuture(task.get());
        }
        return NetworkRegistry.guard(CompletableFuture.supplyAsync(task, arg_0 -> ((PacketProcessor)processor).scheduleIfPossible(arg_0)), this.payloadId);
    }

    @Override
    public void finishCurrentTask(ConfigurationTask.Type type) {
        throw new UnsupportedOperationException("Attempted to complete a configuration task on the client!");
    }

    @Override
    public PacketFlow flow() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public Player player() {
        if (Minecraft.getInstance().player != null) {
            return Minecraft.getInstance().player;
        }
        throw new UnsupportedOperationException("Cannot retrieve the client player during the configuration phase.");
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this, o);
    }

    public ClientCommonPacketListener listener() {
        return this.listener;
    }

    public Identifier payloadId() {
        return this.payloadId;
    }
}

