/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.extensions.common;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;
import org.jspecify.annotations.Nullable;

public interface IClientItemExtensions {
    public static final IClientItemExtensions DEFAULT = new IClientItemExtensions(){};

    public static IClientItemExtensions of(ItemStack stack) {
        return IClientItemExtensions.of(stack.getItem());
    }

    public static IClientItemExtensions of(Item item) {
        return ClientExtensionsManager.ITEM_EXTENSIONS.getOrDefault(item, DEFAULT);
    }

    default public @Nullable Font getFont(ItemStack stack, FontContext context) {
        return null;
    }

    default public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
        return null;
    }

    default public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        return false;
    }

    default public Model getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
        return original;
    }

    default public Model getGenericArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
        Model replacement = this.getHumanoidArmorModel(itemStack, layerType, original);
        if (replacement != original) {
            if (original instanceof HumanoidModel) {
                HumanoidModel originalHumanoid = (HumanoidModel)original;
                if (replacement instanceof HumanoidModel) {
                    HumanoidModel replacementHumanoid = (HumanoidModel)replacement;
                    ClientHooks.copyModelProperties(originalHumanoid, replacementHumanoid);
                }
            }
            return replacement;
        }
        return original;
    }

    default public void setupModelAnimations(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void renderFirstPersonOverlay(ItemStack stack, EquipmentSlot equipmentSlot, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
    }

    default public boolean shouldBobAsEntity(ItemStack stack) {
        return true;
    }

    default public boolean shouldSpreadAsEntity(ItemStack stack) {
        return true;
    }

    default public int getArmorLayerTintColor(ItemStack stack, EquipmentClientInfo.Layer layer, int layerIdx, int fallbackColor) {
        return EquipmentLayerRenderer.getColorForLayer((EquipmentClientInfo.Layer)layer, (int)fallbackColor);
    }

    default public int getDefaultDyeColor(ItemStack stack) {
        return stack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)stack, (int)0) : 0;
    }

    default public @Nullable Identifier getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, Identifier _default) {
        return null;
    }

    default public Identifier getScopeOverlayTexture(ItemStack stack) {
        return Gui.SPYGLASS_SCOPE_LOCATION;
    }

    public static enum FontContext {
        ITEM_COUNT,
        TOOLTIP,
        SELECTED_ITEM_NAME;

    }
}

