/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer;

import com.google.common.primitives.Ints;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;

public interface ResourceHandler<T extends Resource> {
    public int size();

    public T getResource(int var1);

    public long getAmountAsLong(int var1);

    @ApiStatus.NonExtendable
    default public int getAmountAsInt(int index) {
        return Ints.saturatedCast((long)this.getAmountAsLong(index));
    }

    public long getCapacityAsLong(int var1, T var2);

    @ApiStatus.NonExtendable
    default public int getCapacityAsInt(int index, T resource) {
        return Ints.saturatedCast((long)this.getCapacityAsLong(index, resource));
    }

    public boolean isValid(int var1, T var2);

    public int insert(int var1, T var2, int var3, TransactionContext var4);

    default public int insert(T resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        int inserted = 0;
        int size = this.size();
        for (int index = 0; index < size && (inserted += this.insert(index, resource, amount - inserted, transaction)) != amount; ++index) {
        }
        return inserted;
    }

    public int extract(int var1, T var2, int var3, TransactionContext var4);

    default public int extract(T resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        int extracted = 0;
        int size = this.size();
        for (int index = 0; index < size && (extracted += this.extract(index, resource, amount - extracted, transaction)) != amount; ++index) {
        }
        return extracted;
    }

    public static <T extends Resource> Class<ResourceHandler<T>> asClass() {
        return ResourceHandler.class;
    }
}

