/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.server.command.CommandUtils;

class TagsCommand {
    private static final long CLIPBOARD_TEXT_LIMIT = 32600L;
    private static final long PAGE_SIZE = 8L;
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((Identifier)Identifier.withDefaultNamespace((String)"root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.error.unknown_registry", key.toString()));
    private static final Dynamic2CommandExceptionType UNKNOWN_TAG = new Dynamic2CommandExceptionType((tag, registry) -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.error.unknown_tag", tag.toString(), registry.toString()));
    private static final Dynamic2CommandExceptionType UNKNOWN_ELEMENT = new Dynamic2CommandExceptionType((tag, registry) -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.error.unknown_element", tag.toString(), registry.toString()));

    TagsCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"tags").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceKeyArgument.key(ROOT_REGISTRY_KEY)).suggests(CommandUtils::suggestRegistries).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> TagsCommand.listTags((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTags((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(Commands.literal((String)"get").then(((RequiredArgumentBuilder)Commands.argument((String)"tag", (ArgumentType)IdentifierArgument.id()).suggests(CommandUtils.suggestFromRegistry(r -> r.getTags().map(HolderSet.Named::key).map(TagKey::location)::iterator, "registry", ROOT_REGISTRY_KEY)).executes(ctx -> TagsCommand.listTagElements((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTagElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))).then(Commands.literal((String)"query").then(((RequiredArgumentBuilder)Commands.argument((String)"element", (ArgumentType)IdentifierArgument.id()).suggests(CommandUtils.suggestFromRegistry(Registry::keySet, "registry", ROOT_REGISTRY_KEY)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))));
    }

    private static int listTags(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = CommandUtils.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().lookup(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.identifier()));
        long tagCount = registry.getTags().count();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.registry_key", Component.literal((String)registryKey.identifier().toString()).withStyle(ChatFormatting.GOLD)), "commands.neoforge.tags.tag_count", "commands.neoforge.tags.copy_tag_names", tagCount, page, ChatFormatting.DARK_GREEN, () -> registry.getTags().map(s -> (String)s.unwrap().map(k -> k.location().toString(), Object::toString))), false);
        return (int)tagCount;
    }

    private static int listTagElements(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = CommandUtils.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().lookup(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.identifier()));
        Identifier tagLocation = IdentifierArgument.getId(ctx, (String)"tag");
        TagKey tagKey = TagKey.create((ResourceKey)((ResourceKey)TagsCommand.cast(registryKey)), (Identifier)tagLocation);
        Optional optional = registry.get((TagKey)TagsCommand.cast(tagKey));
        HolderSet.Named tag = (HolderSet.Named)optional.orElseThrow(() -> UNKNOWN_TAG.create((Object)tagKey.location(), (Object)registryKey.identifier()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.tag_key", Component.literal((String)tagKey.registry().identifier().toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)tagKey.location().toString()).withStyle(ChatFormatting.DARK_GREEN)), "commands.neoforge.tags.element_count", "commands.neoforge.tags.copy_element_names", tag.size(), page, ChatFormatting.YELLOW, () -> tag.stream().map(s -> (String)s.unwrap().map(k -> k.identifier().toString(), Object::toString))), false);
        return tag.size();
    }

    private static int queryElementTags(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = CommandUtils.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().lookup(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.identifier()));
        Identifier elementLocation = IdentifierArgument.getId(ctx, (String)"element");
        ResourceKey elementKey = ResourceKey.create((ResourceKey)((ResourceKey)TagsCommand.cast(registryKey)), (Identifier)elementLocation);
        Optional elementHolderOpt = registry.get((ResourceKey)TagsCommand.cast(elementKey));
        Holder elementHolder = (Holder)elementHolderOpt.orElseThrow(() -> UNKNOWN_ELEMENT.create((Object)elementLocation, (Object)registryKey.identifier()));
        long containingTagsCount = elementHolder.tags().count();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.element", Component.literal((String)registryKey.identifier().toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)elementLocation.toString()).withStyle(ChatFormatting.YELLOW)), "commands.neoforge.tags.containing_tag_count", "commands.neoforge.tags.copy_tag_names", containingTagsCount, page, ChatFormatting.DARK_GREEN, () -> elementHolder.tags().map(k -> k.location().toString())), false);
        return (int)containingTagsCount;
    }

    private static MutableComponent createMessage(MutableComponent header, String containsText, String copyHoverText, long count, long currentPage, ChatFormatting elementColor, Supplier<Stream<String>> names) {
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = Mth.clamp((long)currentPage, (long)1L, (long)totalPages);
        MutableComponent containsComponent = CommandUtils.makeTranslatableWithFallback(containsText, count);
        if (count > 0L) {
            StringBuilder clipboardTextBuilder = new StringBuilder();
            boolean reachedLimit = false;
            int countedLines = 0;
            Iterator iterator = names.get().sorted().iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if ((long)(clipboardTextBuilder.length() + line.length()) > 32600L) {
                    reachedLimit = true;
                    break;
                }
                clipboardTextBuilder.append(line).append('\n');
                ++countedLines;
            }
            if (!clipboardTextBuilder.isEmpty()) {
                clipboardTextBuilder.deleteCharAt(clipboardTextBuilder.length() - 1);
            }
            Object clipboardText = reachedLimit ? "(Too many entries to fit in clipboard, showing only first " + countedLines + " entries...)\n" + String.valueOf(clipboardTextBuilder) + "\n(..." + (count - (long)countedLines) + " more entries not shown)" : clipboardTextBuilder.toString();
            containsComponent = ComponentUtils.wrapInSquareBrackets((Component)containsComponent.withStyle(arg_0 -> TagsCommand.lambda$createMessage$26((String)clipboardText, copyHoverText, arg_0)));
            containsComponent = CommandUtils.makeTranslatableWithFallback("commands.neoforge.tags.page_info", containsComponent, actualPage, totalPages);
        }
        MutableComponent tagElements = Component.literal((String)"").append((Component)containsComponent);
        names.get().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(Component::literal).map(t -> t.withStyle(elementColor)).map(t -> CommandUtils.makeTranslatableWithFallback("\n - ").append((Component)t)).forEach(arg_0 -> ((MutableComponent)tagElements).append(arg_0));
        return header.append("\n").append((Component)tagElements);
    }

    private static <O> O cast(Object input) {
        return (O)input;
    }

    private static /* synthetic */ Style lambda$createMessage$26(String clipboardText, String copyHoverText, Style s) {
        return s.withColor(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(clipboardText)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)CommandUtils.makeTranslatableWithFallback(copyHoverText)));
    }
}

