/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionCheck;
import net.neoforged.neoforge.server.command.CommandUtils;

class DimensionsCommand {
    DimensionsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimensions").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_ALL))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.dimensions.list"), true);
            Registry reg = ((CommandSourceStack)ctx.getSource()).registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE);
            HashMap<Identifier, List> types = new HashMap<Identifier, List>();
            for (ServerLevel dim : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                types.computeIfAbsent(reg.getKey((Object)dim.dimensionType()), k -> new ArrayList()).add(dim.getDescription());
            }
            types.keySet().stream().sorted().forEach(key -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
                MutableComponent component = Component.literal((String)(String.valueOf(key) + ": "));
                List components = (List)types.get(key);
                for (int i = 0; i < components.size(); ++i) {
                    component.append((Component)components.get(i));
                    if (i + 1 >= components.size()) continue;
                    component.append(", ");
                }
                return component;
            }, false));
            return 0;
        });
    }
}

