/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.settings;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputQuirks;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.jspecify.annotations.Nullable;

public abstract sealed class KeyModifier
extends Enum<KeyModifier> {
    public static final /* enum */ KeyModifier CONTROL;
    public static final /* enum */ KeyModifier CONTROL_OR_COMMAND;
    public static final /* enum */ KeyModifier SHIFT;
    public static final /* enum */ KeyModifier ALT;
    public static final /* enum */ KeyModifier NONE;
    public static final KeyModifier[] MODIFIER_VALUES;
    private static final /* synthetic */ KeyModifier[] $VALUES;

    public static KeyModifier[] values() {
        return (KeyModifier[])$VALUES.clone();
    }

    public static KeyModifier valueOf(String name) {
        return Enum.valueOf(KeyModifier.class, name);
    }

    public static List<KeyModifier> getActiveModifiers() {
        ArrayList<KeyModifier> modifiers = new ArrayList<KeyModifier>();
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.isActive(null)) continue;
            modifiers.add(keyModifier);
        }
        return modifiers;
    }

    public static KeyModifier getKeyModifier(InputConstants.Key key) {
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.matches(key)) continue;
            return keyModifier;
        }
        return NONE;
    }

    public static boolean isKeyCodeModifier(InputConstants.Key key) {
        return KeyModifier.getKeyModifier(key) != NONE;
    }

    public static KeyModifier valueFromString(String stringValue) {
        try {
            return KeyModifier.valueOf(stringValue);
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return NONE;
        }
    }

    public abstract boolean matches(InputConstants.Key var1);

    public abstract boolean isActive(@Nullable IKeyConflictContext var1);

    public abstract Component getCombinedName(InputConstants.Key var1, Supplier<Component> var2);

    public abstract InputConstants.Key[] codes();

    private static /* synthetic */ KeyModifier[] $values() {
        return new KeyModifier[]{CONTROL, CONTROL_OR_COMMAND, SHIFT, ALT, NONE};
    }

    static {
        KeyModifier[] keyModifierArray;
        CONTROL = new KeyModifier(){
            private static final InputConstants.Key[] KEYS = new InputConstants.Key[]{InputConstants.Type.KEYSYM.getOrCreate(341), InputConstants.Type.KEYSYM.getOrCreate(345)};

            @Override
            public boolean matches(InputConstants.Key key) {
                int keyCode = key.getValue();
                return keyCode == 341 || keyCode == 345;
            }

            @Override
            public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
                return Minecraft.getInstance().hasControlDown();
            }

            @Override
            public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
                return Component.translatable((String)"neoforge.controlsgui.control", (Object[])new Object[]{defaultLogic.get()});
            }

            @Override
            public InputConstants.Key[] codes() {
                return KEYS;
            }
        };
        CONTROL_OR_COMMAND = new KeyModifier(){
            private static final InputConstants.Key[] COMMAND_KEYS = new InputConstants.Key[]{InputConstants.Type.KEYSYM.getOrCreate(343), InputConstants.Type.KEYSYM.getOrCreate(347)};

            @Override
            public boolean matches(InputConstants.Key key) {
                if (InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY) {
                    int keyCode = key.getValue();
                    return keyCode == 343 || keyCode == 347;
                }
                return CONTROL.matches(key);
            }

            @Override
            public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
                if (InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY) {
                    Minecraft minecraft = Minecraft.getInstance();
                    Window window = minecraft.getWindow();
                    return InputConstants.isKeyDown((Window)window, (int)343) || InputConstants.isKeyDown((Window)window, (int)347);
                }
                return CONTROL.isActive(conflictContext);
            }

            @Override
            public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
                if (InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY) {
                    return Component.translatable((String)"neoforge.controlsgui.control.mac", (Object[])new Object[]{defaultLogic.get()});
                }
                return CONTROL.getCombinedName(key, defaultLogic);
            }

            @Override
            public InputConstants.Key[] codes() {
                if (InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY) {
                    return COMMAND_KEYS;
                }
                return CONTROL.codes();
            }
        };
        SHIFT = new KeyModifier(){
            private static final InputConstants.Key[] KEYS = new InputConstants.Key[]{InputConstants.Type.KEYSYM.getOrCreate(340), InputConstants.Type.KEYSYM.getOrCreate(344)};

            @Override
            public boolean matches(InputConstants.Key key) {
                return key.getValue() == 340 || key.getValue() == 344;
            }

            @Override
            public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
                return Minecraft.getInstance().hasShiftDown();
            }

            @Override
            public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
                return Component.translatable((String)"neoforge.controlsgui.shift", (Object[])new Object[]{defaultLogic.get()});
            }

            @Override
            public InputConstants.Key[] codes() {
                return KEYS;
            }
        };
        ALT = new KeyModifier(){
            private static final InputConstants.Key[] KEYS = new InputConstants.Key[]{InputConstants.Type.KEYSYM.getOrCreate(342), InputConstants.Type.KEYSYM.getOrCreate(346)};

            @Override
            public boolean matches(InputConstants.Key key) {
                return key.getValue() == 342 || key.getValue() == 346;
            }

            @Override
            public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
                return Minecraft.getInstance().hasAltDown();
            }

            @Override
            public Component getCombinedName(InputConstants.Key keyCode, Supplier<Component> defaultLogic) {
                return Component.translatable((String)"neoforge.controlsgui.alt", (Object[])new Object[]{defaultLogic.get()});
            }

            @Override
            public InputConstants.Key[] codes() {
                return KEYS;
            }
        };
        NONE = new KeyModifier(){
            private static final InputConstants.Key[] KEYS = new InputConstants.Key[0];

            @Override
            public boolean matches(InputConstants.Key key) {
                return false;
            }

            @Override
            public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
                if (conflictContext != null && !conflictContext.conflicts(KeyConflictContext.IN_GAME)) {
                    for (KeyModifier keyModifier : MODIFIER_VALUES) {
                        if (!keyModifier.isActive(conflictContext)) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
                return defaultLogic.get();
            }

            @Override
            public InputConstants.Key[] codes() {
                return KEYS;
            }
        };
        $VALUES = KeyModifier.$values();
        if (InputQuirks.ON_OSX) {
            KeyModifier[] keyModifierArray2 = new KeyModifier[4];
            keyModifierArray2[0] = SHIFT;
            keyModifierArray2[1] = CONTROL_OR_COMMAND;
            keyModifierArray2[2] = CONTROL;
            keyModifierArray = keyModifierArray2;
            keyModifierArray2[3] = ALT;
        } else {
            KeyModifier[] keyModifierArray3 = new KeyModifier[3];
            keyModifierArray3[0] = SHIFT;
            keyModifierArray3[1] = CONTROL;
            keyModifierArray = keyModifierArray3;
            keyModifierArray3[2] = ALT;
        }
        MODIFIER_VALUES = keyModifierArray;
    }
}

