/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.quad;

public sealed interface BakedColors {
    public static final BakedColors DEFAULT = new PerQuad(-1);

    public int color(int var1);

    public static BakedColors of(int color0, int color1, int color2, int color3) {
        if (color0 == color1 && color0 == color2 && color0 == color3) {
            return BakedColors.of(color0);
        }
        return new PerVertex(color0, color1, color2, color3);
    }

    public static BakedColors of(int color) {
        return color == -1 ? DEFAULT : new PerQuad(color);
    }

    public record PerVertex(int color0, int color1, int color2, int color3) implements BakedColors
    {
        @Override
        public int color(int vertex) {
            return switch (vertex) {
                case 0 -> this.color0;
                case 1 -> this.color1;
                case 2 -> this.color2;
                case 3 -> this.color3;
                default -> throw new IndexOutOfBoundsException(vertex);
            };
        }
    }

    public record PerQuad(int color) implements BakedColors
    {
        @Override
        public int color(int vertex) {
            return this.color;
        }
    }
}

