/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries.datamaps;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.ApiStatus;

public class RegisterDataMapTypesEvent
extends Event
implements IModBusEvent {
    private final Map<ResourceKey<Registry<?>>, Map<Identifier, DataMapType<?, ?>>> attachments;

    @ApiStatus.Internal
    public RegisterDataMapTypesEvent(Map<ResourceKey<Registry<?>>, Map<Identifier, DataMapType<?, ?>>> attachments) {
        this.attachments = attachments;
    }

    public <T, R> void register(DataMapType<R, T> type) {
        ResourceKey registry = type.registryKey();
        if (DataPackRegistriesHooks.getDataPackRegistries().stream().anyMatch(data -> data.key().equals(registry)) && type.networkCodec() != null && DataPackRegistriesHooks.getSyncedRegistry(registry) == null) {
            throw new UnsupportedOperationException("Cannot register synced data map " + String.valueOf(type.id()) + " for datapack registry " + String.valueOf(registry.identifier()) + " that is not synced!");
        }
        Map map = this.attachments.computeIfAbsent(registry, k -> new HashMap());
        if (map.containsKey(type.id())) {
            throw new IllegalArgumentException("Tried to register data map type with ID " + String.valueOf(type.id()) + " to registry " + String.valueOf(registry.identifier()) + " twice");
        }
        map.put(type.id(), type);
    }
}

