/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jspecify.annotations.Nullable;

public abstract class PistonEvent
extends BlockEvent {
    private final Direction direction;
    private final PistonMoveType moveType;

    public PistonEvent(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
        super((LevelAccessor)world, pos, world.getBlockState(pos));
        this.direction = direction;
        this.moveType = moveType;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getFaceOffsetPos() {
        return this.getPos().relative(this.direction);
    }

    public PistonMoveType getPistonMoveType() {
        return this.moveType;
    }

    public @Nullable PistonStructureResolver getStructureHelper() {
        if (this.getLevel() instanceof Level) {
            return new PistonStructureResolver((Level)this.getLevel(), this.getPos(), this.getDirection(), this.getPistonMoveType().isExtend);
        }
        return null;
    }

    public static enum PistonMoveType {
        EXTEND(true),
        RETRACT(false);

        public final boolean isExtend;

        private PistonMoveType(boolean isExtend) {
            this.isExtend = isExtend;
        }
    }

    public static class Pre
    extends PistonEvent
    implements ICancellableEvent {
        public Pre(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }

    public static class Post
    extends PistonEvent {
        public Post(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }
}

