/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.TriState;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityHooks;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class BlockCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<BlockCapability<?, ?>> registry = new CapabilityRegistry<BlockCapability>(BlockCapability::new);
    final Map<Block, List<IBlockCapabilityProvider<T, C>>> providers = new IdentityHashMap<Block, List<IBlockCapabilityProvider<T, C>>>();
    private TriState proxyable = TriState.DEFAULT;

    public static <T, C> BlockCapability<T, C> create(Identifier name, Class<T> typeClass, Class<C> contextClass) {
        return registry.create(name, typeClass, contextClass);
    }

    public static <T> BlockCapability<T, @Nullable Void> createVoid(Identifier name, Class<T> typeClass) {
        return BlockCapability.create(name, typeClass, Void.TYPE);
    }

    public static <T> BlockCapability<T, @Nullable Direction> createSided(Identifier name, Class<T> typeClass) {
        return BlockCapability.create(name, typeClass, Direction.class);
    }

    public static synchronized List<BlockCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    public static synchronized List<BlockCapability<?, ?>> getAllProxyable() {
        return registry.getAll().stream().filter(BlockCapability::isProxyable).toList();
    }

    public boolean isProxyable() {
        return this.proxyable.isTrue();
    }

    private BlockCapability(Identifier name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    void setProxyable(boolean proxyable) {
        if (CapabilityHooks.initFinished) {
            throw new IllegalStateException("Cannot call setProxyable after the RegisterCapabilitiesEvent has been fired.");
        }
        switch (this.proxyable) {
            case DEFAULT: {
                this.proxyable = proxyable ? TriState.TRUE : TriState.FALSE;
                break;
            }
            case TRUE: {
                if (proxyable) break;
                throw new IllegalStateException("Cannot make capability %s non-proxyable because it was already set to be proxyable.".formatted(this.name()));
            }
            case FALSE: {
                if (!proxyable) break;
                throw new IllegalStateException("Cannot make capability %s proxyable because it was already set to be non-proxyable.".formatted(this.name()));
            }
        }
    }

    @ApiStatus.Internal
    public @Nullable T getCapability(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity, C context) {
        pos = pos.immutable();
        if (blockEntity == null) {
            if (state == null) {
                state = level.getBlockState(pos);
            }
            if (state.hasBlockEntity()) {
                blockEntity = level.getBlockEntity(pos);
            }
        } else if (state == null) {
            state = blockEntity.getBlockState();
        }
        for (IBlockCapabilityProvider provider : this.providers.getOrDefault(state.getBlock(), List.of())) {
            Object ret = provider.getCapability(level, pos, state, blockEntity, context);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

