/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.mojang.math.Quadrant;
import com.mojang.math.Transformation;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.model.ComposedModelState;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class UnbakedElementsHelper {
    private static final ModelBaker.PartCache DUMMY_PART_CACHE = vector -> vector;

    private UnbakedElementsHelper() {
    }

    public static List<BlockElement> createUnbakedItemElements(int layerIndex, TextureAtlasSprite sprite) {
        return UnbakedElementsHelper.createUnbakedItemElements(layerIndex, sprite, null);
    }

    public static List<BlockElement> createUnbakedItemElements(int layerIndex, TextureAtlasSprite sprite, @Nullable ExtraFaceData faceData) {
        List elements = ItemModelGenerator.processFrames((int)layerIndex, (String)("layer" + layerIndex), (SpriteContents)sprite.contents());
        if (faceData != null) {
            elements.replaceAll(elem -> new BlockElement(elem.from(), elem.to(), elem.faces(), elem.rotation(), elem.shade(), elem.lightEmission(), faceData));
        }
        return elements;
    }

    public static List<BlockElement> createUnbakedItemMaskElements(int layerIndex, TextureAtlasSprite sprite) {
        return UnbakedElementsHelper.createUnbakedItemMaskElements(layerIndex, sprite, null);
    }

    public static List<BlockElement> createUnbakedItemMaskElements(int layerIndex, TextureAtlasSprite sprite, @Nullable ExtraFaceData faceData) {
        List<BlockElement> elements = UnbakedElementsHelper.createUnbakedItemElements(layerIndex, sprite, faceData);
        elements.removeFirst();
        SpriteContents spriteContents = sprite.contents();
        int width = spriteContents.width();
        int height = spriteContents.height();
        BitSet bits = new BitSet(width * height);
        spriteContents.getUniqueFrames().forEach(frame -> {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (spriteContents.isTransparent(frame, x, y)) continue;
                    bits.set(x + y * width);
                }
            }
        });
        for (int y = 0; y < height; ++y) {
            int xStart = -1;
            for (int x = 0; x < width; ++x) {
                int yEnd;
                boolean opaque = bits.get(x + y * width);
                if (opaque != (xStart == -1)) continue;
                if (xStart == -1) {
                    xStart = x;
                    continue;
                }
                block2: for (yEnd = y + 1; yEnd < height; ++yEnd) {
                    for (int x2 = xStart; x2 <= x; ++x2) {
                        if (!bits.get(x2 + yEnd * width)) break block2;
                    }
                }
                for (int i = xStart; i < x; ++i) {
                    for (int j = y; j < yEnd; ++j) {
                        bits.clear(i + j * width);
                    }
                }
                Vector3f from = new Vector3f((float)(16 * xStart) / (float)width, 16.0f - (float)(16 * yEnd) / (float)height, 7.5f);
                Vector3f to = new Vector3f((float)(16 * x) / (float)width, 16.0f - (float)(16 * y) / (float)height, 8.5f);
                BlockElementFace.UVs northUvs = FaceBakery.defaultFaceUV((Vector3fc)from, (Vector3fc)to, (Direction)Direction.NORTH);
                BlockElementFace.UVs southUvs = FaceBakery.defaultFaceUV((Vector3fc)from, (Vector3fc)to, (Direction)Direction.SOUTH);
                Map<Direction, BlockElementFace> faces = Map.of(Direction.NORTH, new BlockElementFace(null, layerIndex, "layer" + layerIndex, northUvs, Quadrant.R0), Direction.SOUTH, new BlockElementFace(null, layerIndex, "layer" + layerIndex, southUvs, Quadrant.R0));
                elements.add(new BlockElement((Vector3fc)from, (Vector3fc)to, faces, null, true, 0));
                xStart = -1;
            }
        }
        return elements;
    }

    public static void bakeElements(QuadCollection.Builder builder, List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        for (BlockElement element : elements) {
            element.faces().forEach((side, face) -> {
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, Identifier.parse((String)face.texture())));
                BakedQuad quad = FaceBakery.bakeQuad((ModelBaker.PartCache)DUMMY_PART_CACHE, (Vector3fc)element.from(), (Vector3fc)element.to(), (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)side, (ModelState)modelState, (BlockElementRotation)element.rotation(), (boolean)element.shade(), (int)element.lightEmission());
                if (face.cullForDirection() == null) {
                    builder.addUnculledFace(quad);
                } else {
                    builder.addCulledFace(Direction.rotate((Matrix4fc)modelState.transformation().getMatrix(), (Direction)face.cullForDirection()), quad);
                }
            });
        }
    }

    public static List<BakedQuad> bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        if (elements.isEmpty()) {
            return List.of();
        }
        QuadCollection.Builder builder = new QuadCollection.Builder();
        UnbakedElementsHelper.bakeElements(builder, elements, spriteGetter, modelState);
        return builder.build().getAll();
    }

    public static ModelState composeRootTransformIntoModelState(ModelState modelState, Transformation rootTransform) {
        if (rootTransform.isIdentity()) {
            return modelState;
        }
        rootTransform = rootTransform.applyOrigin(new Vector3f(-0.5f, -0.5f, -0.5f));
        return new ComposedModelState(modelState, rootTransform);
    }
}

