/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipePriorityManager
extends SimplePreparableReloadListener<Object2IntMap<ResourceKey<Recipe<?>>>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogManager.getLogger();
    private final RecipeManager recipeManager;
    private Object2IntMap<ResourceKey<Recipe<?>>> recipePriorities = Object2IntMaps.emptyMap();

    public RecipePriorityManager(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    protected Object2IntMap<ResourceKey<Recipe<?>>> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        Identifier resourceLocation = Identifier.fromNamespaceAndPath((String)"neoforge", (String)"recipe_priorities.json");
        for (Resource resource : resourceManager.getResourceStack(resourceLocation)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject jsonobject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    boolean replace = GsonHelper.getAsBoolean((JsonObject)jsonobject, (String)"replace", (boolean)false);
                    if (replace) {
                        map.clear();
                    }
                    JsonObject entriesObject = GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)"entries");
                    for (Map.Entry priorityEntry : entriesObject.entrySet()) {
                        Identifier location = Identifier.parse((String)((String)priorityEntry.getKey()));
                        int priority = ((JsonElement)priorityEntry.getValue()).getAsInt();
                        map.put((Object)ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)location), priority);
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                LOGGER.error("Couldn't read recipe priority list {} in data pack {}", (Object)resourceLocation, (Object)resource.sourcePackId(), (Object)ioexception);
            }
        }
        return Object2IntMaps.unmodifiable((Object2IntMap)map);
    }

    protected void apply(Object2IntMap<ResourceKey<Recipe<?>>> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.recipePriorities = map;
        this.recipeManager.setPriorityMap(this.recipePriorities);
        LOGGER.info("Loaded {} recipe priority overrides", (Object)this.recipePriorities.size());
    }

    public Object2IntMap<ResourceKey<Recipe<?>>> getRecipePriorities() {
        return this.recipePriorities;
    }
}

