/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.fluid;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.ResourceStack;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class FluidUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private FluidUtil() {
    }

    public static FluidStack getStack(ResourceHandler<FluidResource> handler, int index) {
        FluidResource resource = handler.getResource(index);
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return resource.toStack(handler.getAmountAsInt(index));
    }

    public static FluidStack getFirstStackContained(ItemStack stack) {
        ResourceHandler<FluidResource> handler = ItemAccess.forStack(stack).oneByOne().getCapability(Capabilities.Fluid.ITEM);
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        int size = handler.size();
        for (int index = 0; index < size; ++index) {
            FluidStack fluidStack = FluidUtil.getStack(handler, index);
            if (fluidStack.isEmpty()) continue;
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, Level level, BlockPos pos, @Nullable Direction side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, pos, (Object)side);
        return fluidHandler != null && FluidUtil.interactWithFluidHandler(player, hand, pos, fluidHandler);
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, @Nullable BlockPos pos, ResourceHandler<FluidResource> handler) {
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction(player, hand).oneByOne();
        ResourceHandler<FluidResource> handHandler = itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (handHandler == null) {
            return false;
        }
        return !FluidUtil.moveWithSound(handler, handHandler, player.level(), pos, player, true).isEmpty() || !FluidUtil.moveWithSound(handHandler, handler, player.level(), pos, player, false).isEmpty();
    }

    private static FluidStack moveWithSound(ResourceHandler<FluidResource> from, ResourceHandler<FluidResource> to, Level level, @Nullable BlockPos pos, @Nullable Player player, boolean pickup) {
        if (player == null && pos == null) {
            throw new IllegalArgumentException("Either player or pos must be provided.");
        }
        ResourceStack<FluidResource> moved = ResourceHandlerUtil.moveFirst(from, to, fr -> true, Integer.MAX_VALUE, null);
        if (moved == null) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = moved.resource().toStack(moved.amount());
        FluidUtil.playSoundAndGameEvent(stack, level, pos, player, pickup);
        return stack;
    }

    private static void playSoundAndGameEvent(FluidStack stack, Level level, @Nullable BlockPos blockPos, @Nullable Player player, boolean pickup) {
        if (player == null && blockPos == null) {
            throw new IllegalArgumentException("Either player or blockPos must be provided.");
        }
        Vec3 position = blockPos != null ? Vec3.atCenterOf((Vec3i)blockPos) : new Vec3(player.getX(), player.getY() + 0.5, player.getZ());
        SoundEvent soundEvent = stack.getFluidType().getSound(stack, pickup ? SoundActions.BUCKET_FILL : SoundActions.BUCKET_EMPTY);
        if (soundEvent != null) {
            level.playSound(null, position.x, position.y, position.z, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.gameEvent((Entity)player, (Holder)(pickup ? GameEvent.FLUID_PICKUP : GameEvent.FLUID_PLACE), position);
    }

    public static FluidStack tryPickupFluid(@Nullable ResourceHandler<FluidResource> destination, @Nullable Player player, Level level, BlockPos pos, @Nullable Direction side) {
        if (destination == null) {
            return FluidStack.EMPTY;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            Fluid fluid = level.getFluidState(pos).getType();
            if (fluid == Fluids.EMPTY) {
                return FluidStack.EMPTY;
            }
            try (Transaction tx = Transaction.openRoot();){
                FluidResource resource = FluidResource.of(fluid);
                int inserted = destination.insert(resource, 1000, tx);
                if (inserted != 1000) {
                    FluidStack fluidStack = FluidStack.EMPTY;
                    return fluidStack;
                }
                if (level.getFluidState(pos).getType() != fluid) {
                    FluidStack fluidStack = FluidStack.EMPTY;
                    return fluidStack;
                }
                ItemStack pickedUpStack = bucketPickup.pickupBlock((LivingEntity)player, (LevelAccessor)level, pos, level.getBlockState(pos));
                Object object = pickedUpStack.getItem();
                if (!(object instanceof BucketItem)) {
                    if (!pickedUpStack.isEmpty()) {
                        LOGGER.warn("Picked up stack is not a bucket. Fluid {} at {} in {} picked up as {}.", new Object[]{BuiltInRegistries.FLUID.getKey((Object)fluid), pos, level.dimension().identifier(), pickedUpStack});
                    }
                    object = FluidStack.EMPTY;
                    return object;
                }
                BucketItem bucket = (BucketItem)object;
                FluidStack extracted = new FluidStack(bucket.content, 1000);
                if (!resource.matches(extracted)) {
                    LOGGER.warn("Fluid removed without successfully being picked up. Fluid {} at {} in {} matched requested type, but after performing pickup was {}.", new Object[]{BuiltInRegistries.FLUID.getKey((Object)fluid), pos, level.dimension().identifier(), BuiltInRegistries.FLUID.getKey((Object)bucket.content)});
                    FluidStack fluidStack = FluidStack.EMPTY;
                    return fluidStack;
                }
                tx.commit();
                FluidUtil.playSoundAndGameEvent(extracted, level, pos, player, true);
                FluidStack fluidStack = extracted;
                return fluidStack;
            }
        }
        ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, pos, state, null, (Object)side);
        if (fluidHandler == null) {
            return FluidStack.EMPTY;
        }
        return FluidUtil.moveWithSound(fluidHandler, destination, level, pos, player, true);
    }

    public static FluidStack tryPlaceFluid(@Nullable ResourceHandler<FluidResource> source, @Nullable Player player, Level level, InteractionHand hand, BlockPos pos) {
        if (source == null) {
            return FluidStack.EMPTY;
        }
        int size = source.size();
        for (int index = 0; index < size; ++index) {
            FluidResource resource = source.getResource(index);
            if (resource.isEmpty()) continue;
            try (Transaction tx = Transaction.openRoot();){
                int amount = source.extract(index, resource, 1000, tx);
                if (amount != 1000 || !FluidUtil.tryPlaceFluid(resource, player, level, hand, pos)) continue;
                tx.commit();
                FluidStack fluidStack = resource.toStack(1000);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    public static boolean tryPlaceFluid(FluidResource resource, @Nullable Player player, Level level, InteractionHand hand, BlockPos pos) {
        LiquidBlockContainer lbc;
        boolean canDestContainFluid;
        FluidStack stack = resource.toStack(1000);
        FluidType fluidType = resource.getFluidType();
        if (stack.isEmpty() || !fluidType.canBePlacedInLevel((BlockAndTintGetter)level, pos, stack)) {
            return false;
        }
        ItemStack handItem = player == null ? ItemStack.EMPTY : player.getItemInHand(hand);
        BlockPlaceContext context = new BlockPlaceContext(level, player, hand, handItem, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false));
        BlockState destBlockState = level.getBlockState(pos);
        boolean isDestReplaceable = destBlockState.canBeReplaced(context);
        Block block = destBlockState.getBlock();
        boolean bl = canDestContainFluid = block instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).canPlaceLiquid((LivingEntity)player, (BlockGetter)level, pos, destBlockState, resource.getFluid());
        if (!(destBlockState.isAir() || isDestReplaceable || canDestContainFluid)) {
            return false;
        }
        if (fluidType.isVaporizedOnPlacement(level, pos, stack)) {
            fluidType.onVaporize((LivingEntity)player, level, pos, stack);
            return true;
        }
        if (canDestContainFluid) {
            lbc = (LiquidBlockContainer)destBlockState.getBlock();
            lbc.placeLiquid((LevelAccessor)level, pos, destBlockState, fluidType.getStateForPlacement((BlockAndTintGetter)level, pos, stack));
        } else {
            if (!level.isClientSide() && isDestReplaceable && !destBlockState.liquid()) {
                level.destroyBlock(pos, true);
            }
            BlockState state = fluidType.getBlockForFluidState((BlockAndTintGetter)level, pos, resource.getFluid().defaultFluidState());
            level.setBlock(pos, state, 11);
        }
        FluidUtil.playSoundAndGameEvent(stack, level, pos, player, false);
        return true;
    }
}

