/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.energy;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ItemAccessEnergyHandler
implements EnergyHandler {
    protected final ItemAccess itemAccess;
    protected final Item validItem;
    protected final DataComponentType<Integer> energyComponent;
    protected final int capacity;
    protected final int maxInsert;
    protected final int maxExtract;

    public ItemAccessEnergyHandler(ItemAccess itemAccess, DataComponentType<Integer> energyComponent, int capacity) {
        this(itemAccess, energyComponent, capacity, capacity);
    }

    public ItemAccessEnergyHandler(ItemAccess itemAccess, DataComponentType<Integer> energyComponent, int capacity, int maxTransfer) {
        this(itemAccess, energyComponent, capacity, maxTransfer, maxTransfer);
    }

    public ItemAccessEnergyHandler(ItemAccess itemAccess, DataComponentType<Integer> energyComponent, int capacity, int maxInsert, int maxExtract) {
        TransferPreconditions.checkNonNegative(capacity);
        TransferPreconditions.checkNonNegative(maxInsert);
        TransferPreconditions.checkNonNegative(maxExtract);
        this.itemAccess = itemAccess;
        this.validItem = itemAccess.getResource().getItem();
        this.energyComponent = energyComponent;
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    protected int getAmountFrom(ItemResource accessResource) {
        if (!accessResource.is(this.validItem)) {
            return 0;
        }
        return (Integer)accessResource.getOrDefault(this.energyComponent, 0);
    }

    protected ItemResource update(ItemResource accessResource, int newAmount) {
        return accessResource.with((DataComponentType)this.energyComponent, (Object)newAmount);
    }

    @Override
    public long getAmountAsLong() {
        return (long)this.itemAccess.getAmount() * (long)this.getAmountFrom(this.itemAccess.getResource());
    }

    @Override
    public long getCapacityAsLong() {
        ItemResource accessResource = this.itemAccess.getResource();
        if (!accessResource.is(this.validItem)) {
            return 0L;
        }
        return (long)this.itemAccess.getAmount() * (long)this.capacity;
    }

    @Override
    public int insert(int amount, TransactionContext transaction) {
        ItemResource filledResource;
        TransferPreconditions.checkNonNegative(amount);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        int amountPerItem = Math.min(this.maxInsert, amount / accessAmount);
        if (amountPerItem == 0) {
            return 0;
        }
        ItemResource accessResource = this.itemAccess.getResource();
        if (!accessResource.is(this.validItem)) {
            return 0;
        }
        int currentAmountPerItem = this.getAmountFrom(accessResource);
        int insertedPerItem = Math.min(amountPerItem, this.capacity - currentAmountPerItem);
        if (insertedPerItem > 0 && !(filledResource = this.update(accessResource, currentAmountPerItem + insertedPerItem)).isEmpty()) {
            return insertedPerItem * this.itemAccess.exchange(filledResource, accessAmount, transaction);
        }
        return 0;
    }

    @Override
    public int extract(int amount, TransactionContext transaction) {
        ItemResource emptiedResource;
        TransferPreconditions.checkNonNegative(amount);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        int amountPerItem = Math.min(this.maxExtract, amount / accessAmount);
        if (amountPerItem == 0) {
            return 0;
        }
        ItemResource accessResource = this.itemAccess.getResource();
        int currentAmountPerItem = this.getAmountFrom(accessResource);
        int extractedPerItem = Math.min(amountPerItem, currentAmountPerItem);
        if (extractedPerItem > 0 && !(emptiedResource = this.update(accessResource, currentAmountPerItem - extractedPerItem)).isEmpty()) {
            return extractedPerItem * this.itemAccess.exchange(emptiedResource, accessAmount, transaction);
        }
        return 0;
    }
}

