/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record RegistryDataMapSyncPayload<T>(ResourceKey<? extends Registry<T>> registryKey, Map<Identifier, Map<ResourceKey<T>, ?>> dataMaps) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RegistryDataMapSyncPayload<?>> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"registry_data_map_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RegistryDataMapSyncPayload<?>> STREAM_CODEC = StreamCodec.ofMember(RegistryDataMapSyncPayload::write, RegistryDataMapSyncPayload::decode);
    private static final Gson GSON = new Gson();

    public static <T> RegistryDataMapSyncPayload<T> decode(RegistryFriendlyByteBuf buf) {
        ResourceKey registryKey = buf.readRegistryKey();
        Map attach = buf.readMap(FriendlyByteBuf::readIdentifier, (b1, key) -> {
            DataMapType dataMap = RegistryManager.getDataMap(registryKey, key);
            return b1.readMap(bf -> bf.readResourceKey(registryKey), bf -> RegistryDataMapSyncPayload.readJsonWithRegistryCodec((RegistryFriendlyByteBuf)bf, dataMap.networkCodec()));
        });
        return new RegistryDataMapSyncPayload<T>(registryKey, attach);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeResourceKey(this.registryKey);
        buf.writeMap(this.dataMaps, FriendlyByteBuf::writeIdentifier, (b1, key, attach) -> {
            DataMapType dataMap = RegistryManager.getDataMap(this.registryKey, key);
            b1.writeMap(attach, FriendlyByteBuf::writeResourceKey, (bf, value) -> RegistryDataMapSyncPayload.writeJsonWithRegistryCodec((RegistryFriendlyByteBuf)bf, dataMap.networkCodec(), value));
        });
    }

    public CustomPacketPayload.Type<RegistryDataMapSyncPayload<?>> type() {
        return TYPE;
    }

    private static <T> T readJsonWithRegistryCodec(RegistryFriendlyByteBuf buf, Codec<T> codec) {
        JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (String)buf.readUtf(), JsonElement.class);
        DataResult dataresult = codec.parse((DynamicOps)buf.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonelement);
        return (T)dataresult.getOrThrow(name -> new DecoderException("Failed to decode json: " + name));
    }

    private static <T> void writeJsonWithRegistryCodec(RegistryFriendlyByteBuf buf, Codec<T> codec, T value) {
        DataResult dataresult = codec.encodeStart((DynamicOps)buf.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), value);
        buf.writeUtf(GSON.toJson((JsonElement)dataresult.getOrThrow(message -> new EncoderException("Failed to encode: " + message + " " + String.valueOf(value)))));
    }
}

