/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.permissions.PermissionCheck;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.command.CommandUtils;
import org.slf4j.Logger;

class DumpCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((Identifier)Identifier.withDefaultNamespace((String)"root"));
    private static final String ALPHABETICAL_SORT_PARAM = "alphabetical_sort";
    private static final String PRINT_NUMERIC_ID_PARAM = "print_numeric_ids";
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.dump.error.unknown_registry", key));

    DumpCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dump").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_OWNERS))).then(Commands.literal((String)"registry").then(((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceKeyArgument.key(ROOT_REGISTRY_KEY)).suggests(CommandUtils::suggestRegistries).executes(context -> DumpCommand.dumpRegistry((CommandContext<CommandSourceStack>)context, false, false))).then(((RequiredArgumentBuilder)Commands.argument((String)ALPHABETICAL_SORT_PARAM, (ArgumentType)BoolArgumentType.bool()).executes(context -> DumpCommand.dumpRegistry((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)ALPHABETICAL_SORT_PARAM), false))).then(Commands.argument((String)PRINT_NUMERIC_ID_PARAM, (ArgumentType)BoolArgumentType.bool()).executes(context -> DumpCommand.dumpRegistry((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)ALPHABETICAL_SORT_PARAM), BoolArgumentType.getBool((CommandContext)context, (String)PRINT_NUMERIC_ID_PARAM)))))));
    }

    private static int dumpRegistry(CommandContext<CommandSourceStack> ctx, boolean alphabeticalSort, boolean printNumericIds) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = CommandUtils.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().lookup(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.identifier()));
        String fileLocationForErrorReporting = "";
        try {
            Path registryDumpDirectory = FMLLoader.getCurrent().getGameDir().resolve("dumps").resolve("registry");
            Path registryNamespaceDirectory = registryDumpDirectory.resolve(registryKey.identifier().getNamespace().replaceAll("[/:.]", "_"));
            Files.createDirectories(registryNamespaceDirectory, new FileAttribute[0]);
            String fileName = registryKey.identifier().getPath().replaceAll("[/:.]", "_") + ".txt";
            Path registryDumpFile = registryNamespaceDirectory.resolve(fileName);
            fileLocationForErrorReporting = registryDumpFile.toString();
            try (OutputStream outputStream = Files.newOutputStream(registryDumpFile, new OpenOption[0]);){
                List<Identifier> sortedRegistryKeys = DumpCommand.getSortedRegistryKeys(alphabeticalSort, printNumericIds, registry);
                for (Identifier registryKeys : sortedRegistryKeys) {
                    Object results = registryKeys.toString();
                    if (printNumericIds) {
                        results = registry.getId(registryKeys) + " - " + (String)results;
                    }
                    outputStream.write(((String)results + "\n").getBytes());
                }
            }
            MutableComponent filePathComponent = Component.literal((String)("..." + String.valueOf(FMLLoader.getCurrent().getGameDir().relativize(registryDumpFile)))).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD);
            if (!FMLEnvironment.getDist().isDedicatedServer()) {
                filePathComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(registryDumpFile)));
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.dump.success", Component.literal((String)registryKey.identifier().toString()).withStyle(ChatFormatting.YELLOW), filePathComponent), false);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.dump.failure", Component.literal((String)registryKey.identifier().toString()).withStyle(ChatFormatting.YELLOW), Component.literal((String)fileLocationForErrorReporting).withStyle(ChatFormatting.GOLD)));
            LOGGER.error("Failed to create new file with " + String.valueOf(registryKey) + " registry's contents at " + fileLocationForErrorReporting, (Throwable)e);
            return 0;
        }
    }

    private static List<Identifier> getSortedRegistryKeys(boolean alphabeticalSort, boolean printNumericIds, Registry<?> registry) {
        List<Identifier> sortedRegistryNames = new ArrayList<Identifier>(registry.keySet());
        if (alphabeticalSort) {
            sortedRegistryNames.sort(Identifier::compareNamespaced);
        } else if (printNumericIds) {
            sortedRegistryNames = sortedRegistryNames.stream().sorted(Comparator.comparingInt(arg_0 -> registry.getId(arg_0))).toList();
        }
        return sortedRegistryNames;
    }
}

