/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.multiplayer.LevelLoadTracker;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterDimensionTransitionScreenEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class DimensionTransitionScreenManager {
    private static final Map<Pair<ResourceKey<Level>, ResourceKey<Level>>, ReceivingLevelScreenFactory> conditionalDimensionEffects = new HashMap<Pair<ResourceKey<Level>, ResourceKey<Level>>, ReceivingLevelScreenFactory>();
    private static final Map<ResourceKey<Level>, ReceivingLevelScreenFactory> toDimensionTransitions = new HashMap<ResourceKey<Level>, ReceivingLevelScreenFactory>();
    private static final Map<ResourceKey<Level>, ReceivingLevelScreenFactory> fromDimensionTransitions = new HashMap<ResourceKey<Level>, ReceivingLevelScreenFactory>();

    @ApiStatus.Internal
    static void init() {
        ModLoader.postEventWrapContainerInModOrder((Event)new RegisterDimensionTransitionScreenEvent(conditionalDimensionEffects, toDimensionTransitions, fromDimensionTransitions));
    }

    public static ReceivingLevelScreenFactory getScreenFromLevel(@Nullable Level target, @Nullable Level source) {
        if (source == null) {
            return DimensionTransitionScreenManager.getScreen(null, null);
        }
        if (target == null) {
            return DimensionTransitionScreenManager.getScreen(null, (ResourceKey<Level>)source.dimension());
        }
        return DimensionTransitionScreenManager.getScreen((ResourceKey<Level>)target.dimension(), (ResourceKey<Level>)source.dimension());
    }

    public static ReceivingLevelScreenFactory getScreen(@Nullable ResourceKey<Level> toDimension, @Nullable ResourceKey<Level> fromDimension) {
        ReceivingLevelScreenFactory conditionalScreen = conditionalDimensionEffects.get(Pair.of(toDimension, fromDimension));
        if (conditionalScreen != null) {
            return conditionalScreen;
        }
        ReceivingLevelScreenFactory toDim = toDimensionTransitions.get(toDimension);
        if (toDim != null) {
            return toDim;
        }
        ReceivingLevelScreenFactory fromDim = fromDimensionTransitions.get(fromDimension);
        if (fromDim != null) {
            return fromDim;
        }
        return LevelLoadingScreen::new;
    }

    public static interface ReceivingLevelScreenFactory {
        public LevelLoadingScreen create(LevelLoadTracker var1, LevelLoadingScreen.Reason var2);
    }
}

