/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public abstract class StackCopySlot
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private @Nullable ItemStack cachedReturnedStack = null;

    public StackCopySlot(int x, int y) {
        super(emptyInventory, 0, x, y);
    }

    protected abstract ItemStack getStackCopy();

    protected abstract void setStackCopy(ItemStack var1);

    public final ItemStack getItem() {
        this.cachedReturnedStack = this.getStackCopy();
        return this.cachedReturnedStack;
    }

    public final void set(ItemStack stack) {
        this.setStackCopy(stack);
        this.cachedReturnedStack = stack;
    }

    public final void setChanged() {
        if (this.cachedReturnedStack != null && !ItemStack.matches((ItemStack)this.cachedReturnedStack, (ItemStack)this.getStackCopy())) {
            this.set(this.cachedReturnedStack);
        }
    }

    public final ItemStack remove(int amount) {
        ItemStack stack = this.getStackCopy().copy();
        ItemStack ret = stack.split(amount);
        this.set(stack);
        this.cachedReturnedStack = null;
        return ret;
    }
}

