/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.blockstate;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import org.jspecify.annotations.Nullable;

public final class UnbakedMutator {
    private final Map<Class<?>, Handler<?>> handlers;

    private UnbakedMutator(Map<Class<?>, Handler<?>> handlers) {
        this.handlers = Collections.unmodifiableMap(handlers);
    }

    public <T extends BlockStateModel.Unbaked> T apply(T unbaked) {
        Handler<T> handler = this.getHandler(unbaked);
        if (handler == null) {
            throw new UnsupportedOperationException("This unbaked transform cannot be applied to unbaked model " + String.valueOf(unbaked.getClass()) + ", it only supports: " + String.valueOf(this.handlers.keySet()));
        }
        return handler.apply(unbaked);
    }

    private <T extends BlockStateModel.Unbaked> @Nullable Handler<T> getHandler(T unbaked) {
        return this.handlers.get(unbaked.getClass());
    }

    public static Builder builder() {
        return new Builder();
    }

    private record Handler<T>(Class<T> supportedClass, UnaryOperator<T> operator) {
        public T apply(BlockStateModel.Unbaked unbaked) {
            return (T)this.operator.apply(this.supportedClass.cast(unbaked));
        }
    }

    public static final class Builder {
        private final Map<Class<?>, Handler<?>> handlers = new IdentityHashMap();

        private Builder() {
        }

        public <T extends BlockStateModel.Unbaked> Builder add(Class<T> supportedClass, UnaryOperator<T> operator) {
            if (this.handlers.containsKey(supportedClass)) {
                throw new IllegalStateException("There is already a mutator registered for " + String.valueOf(supportedClass));
            }
            this.handlers.put(supportedClass, new Handler<T>(supportedClass, operator));
            return this;
        }

        public UnbakedMutator build() {
            return new UnbakedMutator(this.handlers);
        }
    }
}

