/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraftforge.installer.ui.TranslatedMessage;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TargetValidator {
    @NotNull
    public ValidationResult validate(File var1);

    default public TargetValidator and(TargetValidator other) {
        return target -> this.validate(target).combine(() -> other.validate(target));
    }

    public static TargetValidator isDirectory() {
        return target -> target.isDirectory() ? ValidationResult.valid() : ValidationResult.invalid(true, "installer.target.error.notdirectory");
    }

    public static TargetValidator shouldExist(boolean critical) {
        return target -> target.exists() ? ValidationResult.valid() : ValidationResult.invalid(critical, critical ? "installer.target.error.directory.doesntexist.critical" : "installer.target.error.directory.doesntexist.create");
    }

    public static TargetValidator shouldBeEmpty() {
        return target -> Objects.requireNonNull(target.list()).length == 0 ? ValidationResult.valid() : ValidationResult.invalid(false, "installer.target.error.directory.notempty");
    }

    public static TargetValidator isMCInstallationDirectory() {
        return target -> new File(target, "launcher_profiles.json").exists() || new File(target, "launcher_profiles_microsoft_store.json").exists() ? ValidationResult.valid() : ValidationResult.invalid(true, "installer.target.error.missingprofile");
    }

    public static class ValidationResult {
        private static final ValidationResult VALID = new ValidationResult(true, false, new TranslatedMessage("", new Object[0]));
        public final boolean valid;
        public final boolean critical;
        public final TranslatedMessage message;

        private ValidationResult(boolean valid, boolean critical, TranslatedMessage message) {
            this.valid = valid;
            this.critical = critical;
            this.message = message;
        }

        public static ValidationResult valid() {
            return VALID;
        }

        public static ValidationResult invalid(boolean critical, String messageKey) {
            return new ValidationResult(false, critical, new TranslatedMessage(messageKey, new Object[0]));
        }

        public ValidationResult combine(Supplier<ValidationResult> other) {
            return this.valid ? other.get() : this;
        }
    }
}

