/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.include.com.google.common.base.Preconditions;

@ApiStatus.Internal
public class VanillaClassToKey {
    public static ResourceLocation convert(Class<?> cls) {
        Preconditions.checkArgument((boolean)cls.getPackageName().startsWith("net.minecraft"), (Object)("Automatic name conversion can only be applied to net.minecraft classes. Provided: " + cls.getName()));
        Preconditions.checkArgument((!cls.getSimpleName().isEmpty() ? 1 : 0) != 0, (Object)("Automatic name conversion can only happen for identifiable classes (per Class#getSimpleName()). Provided: " + cls.getName()));
        StringBuilder sb = new StringBuilder();
        cls.getSimpleName().codePoints().forEachOrdered(value -> {
            if (Character.isUpperCase(value)) {
                sb.append('_');
                sb.append(Character.toString(Character.toLowerCase(value)));
            } else {
                sb.append(Character.toString(value));
            }
        });
        return ResourceLocation.withDefaultNamespace((String)sb.substring(1));
    }
}

