/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final String namespace;
    private final Map<DeferredHolder<T, ? extends T>, Supplier<? extends T>> entries = new LinkedHashMap<DeferredHolder<T, ? extends T>, Supplier<? extends T>>();
    private final Set<DeferredHolder<T, ? extends T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private final Map<ResourceLocation, ResourceLocation> aliases = new HashMap<ResourceLocation, ResourceLocation>();
    @Nullable
    private Registry<T> customRegistry;
    @Nullable
    private RegistryHolder<T> registryHolder;
    private boolean seenRegisterEvent = false;
    private boolean seenNewRegistryEvent = false;
    private boolean registeredEventBus = false;

    public static <T> DeferredRegister<T> create(Registry<T> registry, String namespace) {
        return new DeferredRegister<T>(registry.key(), namespace);
    }

    public static <T> DeferredRegister<T> create(ResourceKey<? extends Registry<T>> key, String namespace) {
        return new DeferredRegister<T>(key, namespace);
    }

    public static <B> DeferredRegister<B> create(ResourceLocation registryName, String modid) {
        return new DeferredRegister(ResourceKey.createRegistryKey((ResourceLocation)registryName), modid);
    }

    public static Items createItems(String modid) {
        return new Items(modid);
    }

    public static Blocks createBlocks(String modid) {
        return new Blocks(modid);
    }

    public static DataComponents createDataComponents(ResourceKey<Registry<DataComponentType<?>>> registryKey, String modid) {
        return new DataComponents(registryKey, modid);
    }

    public static Entities createEntities(String modid) {
        return new Entities(modid);
    }

    protected DeferredRegister(ResourceKey<? extends Registry<T>> registryKey, String namespace) {
        this.registryKey = Objects.requireNonNull(registryKey);
        this.namespace = Objects.requireNonNull(namespace);
    }

    public <I extends T> DeferredHolder<T, I> register(String name, Supplier<? extends I> sup) {
        return this.register(name, (ResourceLocation key) -> sup.get());
    }

    public <I extends T> DeferredHolder<T, I> register(String name, Function<ResourceLocation, ? extends I> func) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(func);
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        DeferredHolder<T, I> ret = this.createHolder(this.registryKey, key);
        if (this.entries.putIfAbsent(ret, () -> func.apply(key)) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    protected <I extends T> DeferredHolder<T, I> createHolder(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation key) {
        return DeferredHolder.create(registryKey, key);
    }

    public Registry<T> makeRegistry(Consumer<RegistryBuilder<T>> consumer) {
        return this.makeRegistry(this.registryKey.location(), consumer);
    }

    public Supplier<Registry<T>> getRegistry() {
        if (this.registryHolder == null) {
            this.registryHolder = new RegistryHolder(this.registryKey);
        }
        return this.registryHolder;
    }

    public TagKey<T> createTagKey(String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)path));
    }

    public TagKey<T> createTagKey(ResourceLocation location) {
        Objects.requireNonNull(location);
        return TagKey.create(this.registryKey, (ResourceLocation)location);
    }

    public void addAlias(ResourceLocation from, ResourceLocation to) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot add aliases to DeferredRegister after RegisterEvent has been fired.");
        }
        this.aliases.put(from, to);
    }

    public void register(IEventBus bus) {
        if (this.registeredEventBus) {
            throw new IllegalStateException("Cannot register DeferredRegister to more than one event bus.");
        }
        this.registeredEventBus = true;
        bus.addListener(this::addEntries);
        bus.addListener(this::addRegistry);
    }

    public Collection<DeferredHolder<T, ? extends T>> getEntries() {
        return this.entriesView;
    }

    public ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    public ResourceLocation getRegistryName() {
        return this.registryKey.location();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private Registry<T> makeRegistry(ResourceLocation registryName, Consumer<RegistryBuilder<T>> consumer) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (BuiltInRegistries.REGISTRY.containsKey(registryName) || this.customRegistry != null) {
            throw new IllegalStateException("Cannot create a registry that already exists - " + String.valueOf(this.registryKey));
        }
        if (this.seenNewRegistryEvent) {
            throw new IllegalStateException("Cannot create a registry after NewRegistryEvent was fired");
        }
        RegistryBuilder registryBuilder = new RegistryBuilder(this.registryKey);
        consumer.accept(registryBuilder);
        this.customRegistry = registryBuilder.create();
        this.registryHolder = new RegistryHolder(this.registryKey);
        this.registryHolder.registry = this.customRegistry;
        return this.customRegistry;
    }

    private void addEntries(RegisterEvent event) {
        if (!event.getRegistryKey().equals(this.registryKey)) {
            return;
        }
        this.seenRegisterEvent = true;
        Registry registry = event.getRegistry(this.registryKey);
        this.aliases.forEach((arg_0, arg_1) -> registry.addAlias(arg_0, arg_1));
        for (Map.Entry e : this.entries.entrySet()) {
            event.register(this.registryKey, e.getKey().getId(), () -> ((Supplier)e.getValue()).get());
            e.getKey().bind(false);
        }
    }

    private void addRegistry(NewRegistryEvent event) {
        this.seenNewRegistryEvent = true;
        if (this.customRegistry != null) {
            event.register(this.customRegistry);
        }
    }

    public static class Items
    extends DeferredRegister<Item> {
        protected Items(String namespace) {
            super(Registries.ITEM, namespace);
        }

        public <I extends Item> DeferredItem<I> register(String name, Function<ResourceLocation, ? extends I> func) {
            return (DeferredItem)super.register(name, func);
        }

        public <I extends Item> DeferredItem<I> register(String name, Supplier<? extends I> sup) {
            return this.register(name, (T key) -> (Item)sup.get());
        }

        public DeferredItem<BlockItem> registerSimpleBlockItem(String name, Supplier<? extends Block> block, Item.Properties properties) {
            return this.register(name, (T key) -> new BlockItem((Block)block.get(), properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key)).useBlockDescriptionPrefix()));
        }

        public DeferredItem<BlockItem> registerSimpleBlockItem(String name, Supplier<? extends Block> block) {
            return this.registerSimpleBlockItem(name, block, new Item.Properties());
        }

        public DeferredItem<BlockItem> registerSimpleBlockItem(Holder<Block> block, Item.Properties properties) {
            return this.registerSimpleBlockItem(((ResourceKey)block.unwrapKey().orElseThrow()).location().getPath(), () -> block.value(), properties);
        }

        public DeferredItem<BlockItem> registerSimpleBlockItem(Holder<Block> block) {
            return this.registerSimpleBlockItem(block, new Item.Properties());
        }

        public <I extends Item> DeferredItem<I> registerItem(String name, Function<Item.Properties, ? extends I> func, Item.Properties props) {
            return this.register(name, (T key) -> (Item)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key))));
        }

        public <I extends Item> DeferredItem<I> registerItem(String name, Function<Item.Properties, ? extends I> func) {
            return this.registerItem(name, func, new Item.Properties());
        }

        public DeferredItem<Item> registerSimpleItem(String name, Item.Properties props) {
            return this.registerItem(name, Item::new, props);
        }

        public DeferredItem<Item> registerSimpleItem(String name) {
            return this.registerItem(name, Item::new, new Item.Properties());
        }

        protected <I extends Item> DeferredItem<I> createHolder(ResourceKey<? extends Registry<Item>> registryKey, ResourceLocation key) {
            return DeferredItem.createItem((ResourceKey<Item>)ResourceKey.create(registryKey, (ResourceLocation)key));
        }
    }

    public static class Blocks
    extends DeferredRegister<Block> {
        protected Blocks(String namespace) {
            super(Registries.BLOCK, namespace);
        }

        public <B extends Block> DeferredBlock<B> register(String name, Function<ResourceLocation, ? extends B> func) {
            return (DeferredBlock)super.register(name, func);
        }

        public <B extends Block> DeferredBlock<B> register(String name, Supplier<? extends B> sup) {
            return this.register(name, (T key) -> (Block)sup.get());
        }

        public <B extends Block> DeferredBlock<B> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> func, BlockBehaviour.Properties props) {
            return this.register(name, (T key) -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key))));
        }

        public <B extends Block> DeferredBlock<B> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> func) {
            return this.registerBlock(name, func, BlockBehaviour.Properties.of());
        }

        public DeferredBlock<Block> registerSimpleBlock(String name, BlockBehaviour.Properties props) {
            return this.registerBlock(name, Block::new, props);
        }

        public DeferredBlock<Block> registerSimpleBlock(String name) {
            return this.registerSimpleBlock(name, BlockBehaviour.Properties.of());
        }

        protected <I extends Block> DeferredBlock<I> createHolder(ResourceKey<? extends Registry<Block>> registryKey, ResourceLocation key) {
            return DeferredBlock.createBlock((ResourceKey<Block>)ResourceKey.create(registryKey, (ResourceLocation)key));
        }
    }

    public static class DataComponents
    extends DeferredRegister<DataComponentType<?>> {
        protected DataComponents(ResourceKey<Registry<DataComponentType<?>>> registryKey, String namespace) {
            super(registryKey, namespace);
        }

        public <D> DeferredHolder<DataComponentType<?>, DataComponentType<D>> registerComponentType(String name, UnaryOperator<DataComponentType.Builder<D>> builder) {
            return this.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
        }
    }

    public static class Entities
    extends DeferredRegister<EntityType<?>> {
        protected Entities(String namespace) {
            super(Registries.ENTITY_TYPE, namespace);
        }

        public <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> registerEntityType(String name, EntityType.EntityFactory<E> factory, MobCategory category) {
            return this.registerEntityType(name, factory, category, UnaryOperator.identity());
        }

        public <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> registerEntityType(String name, EntityType.EntityFactory<E> factory, MobCategory category, UnaryOperator<EntityType.Builder<E>> builder) {
            return this.register(name, (ResourceLocation key) -> ((EntityType.Builder)builder.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)key)));
        }
    }

    private static class RegistryHolder<V>
    implements Supplier<Registry<V>> {
        private final ResourceKey<? extends Registry<V>> registryKey;
        private Registry<V> registry = null;

        private RegistryHolder(ResourceKey<? extends Registry<V>> registryKey) {
            this.registryKey = registryKey;
        }

        @Override
        @Nullable
        public Registry<V> get() {
            if (this.registry == null) {
                this.registry = (Registry)BuiltInRegistries.REGISTRY.getValueOrThrow(this.registryKey);
            }
            return this.registry;
        }
    }
}

