/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.fml.ModList;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModMismatchDisconnectedScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Component reason;
    private MultiLineLabel message = MultiLineLabel.EMPTY;
    private MismatchInfoPanel scrollList;
    private final Screen parent;
    private int textHeight;
    private final Path modsDir;
    private final Path logFile;
    private final int listHeight = 140;
    private final Map<ResourceLocation, Component> mismatchedChannelData;

    public ModMismatchDisconnectedScreen(Screen parentScreen, Component reason, Map<ResourceLocation, Component> mismatchedChannelData) {
        super((Component)Component.translatable((String)"disconnect.lost"));
        this.reason = reason;
        this.parent = parentScreen;
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.mismatchedChannelData = mismatchedChannelData;
        this.mismatchedChannelData.replaceAll((id, r) -> {
            TranslatableContents c;
            ComponentContents patt0$temp;
            Optional<String> modDisplayName = ModList.get().getModContainerById(id.getNamespace()).map(mod -> mod.getModInfo().getDisplayName());
            return modDisplayName.isPresent() && (!((patt0$temp = r.getContents()) instanceof TranslatableContents) || !(c = (TranslatableContents)patt0$temp).getKey().equals("neoforge.network.negotiation.failure.mod")) ? Component.translatable((String)"neoforge.network.negotiation.failure.mod", (Object[])new Object[]{modDisplayName.get(), r}) : r;
        });
        this.mismatchedChannelData.forEach((id, r) -> LOGGER.warn("Channel [{}] failed to connect: {}", id, (Object)r.getString()));
    }

    protected void init() {
        int listLeft = Math.max(8, this.width / 2 - 220);
        int listWidth = Math.min(440, this.width - 16);
        this.message = MultiLineLabel.create((Font)this.font, (Component)this.reason, (int)(this.width - 50));
        this.textHeight = this.message.getLineCount() * 9;
        int upperButtonHeight = Math.min((this.height + this.listHeight) / 2 + 25, this.height - 50);
        int lowerButtonHeight = Math.min((this.height + this.listHeight) / 2 + 50, this.height - 25);
        this.scrollList = new MismatchInfoPanel(this.minecraft, listWidth, 140, (this.height - this.listHeight) / 2, listLeft);
        this.addRenderableWidget((GuiEventListener)this.scrollList);
        int buttonWidth = Math.min(210, this.width / 2 - 20);
        this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)true).create(Math.max(this.width / 4 - buttonWidth / 2, listLeft), upperButtonHeight, buttonWidth, 20, (Component)Component.translatable((String)"fml.modmismatchscreen.simplifiedview"), (b, v) -> this.scrollList.toggleSimplifiedView()));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.file", (Object[])new Object[]{this.logFile.getFileName()})), button -> Util.getPlatform().openFile(this.logFile.toFile())).bounds(Math.min(this.width * 3 / 4 - buttonWidth / 2, listLeft + listWidth - buttonWidth), upperButtonHeight, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.mods.folder", (Object[])new Object[0])), button -> Util.getPlatform().openFile(this.modsDir.toFile())).bounds(Math.max(this.width / 4 - buttonWidth / 2, listLeft), lowerButtonHeight, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.toMenu"), button -> this.minecraft.setScreen(this.parent)).bounds(Math.min(this.width * 3 / 4 - buttonWidth / 2, listLeft + listWidth - buttonWidth), lowerButtonHeight, buttonWidth, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, (this.height - this.listHeight) / 2 - this.textHeight - 36, -5592406);
        int n = this.width / 2;
        int n2 = (this.height - this.listHeight) / 2 - this.textHeight - 18;
        Objects.requireNonNull(this.font);
        this.message.render(guiGraphics, MultiLineLabel.Align.CENTER, n, n2, 9, true, -1);
    }

    class MismatchInfoPanel
    extends ScrollPanel {
        private final int nameIndent = 10;
        private final int tableWidth;
        private final int nameWidth;
        private final int versionWidth;
        private List<Pair<FormattedCharSequence, FormattedCharSequence>> lineTable;
        private int contentSize;
        private boolean oneChannelPerEntry;

        public MismatchInfoPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.nameIndent = 10;
            this.tableWidth = this.width - this.border * 2 - 6 - 10;
            this.nameWidth = this.tableWidth / 2;
            this.versionWidth = this.tableWidth - this.nameWidth;
            this.oneChannelPerEntry = true;
            this.updateListContent();
        }

        private void updateListContent() {
            Map<List<ResourceLocation>, Component> mergedChannelData = this.sortAndMergeChannelData(ModMismatchDisconnectedScreen.this.mismatchedChannelData);
            record Row(MutableComponent name, MutableComponent reason) {
            }
            ArrayList<Row> rows = new ArrayList<Row>();
            if (!mergedChannelData.isEmpty()) {
                rows.add(new Row(Component.translatable((String)"fml.modmismatchscreen.table.channelname"), Component.translatable((String)"fml.modmismatchscreen.table.reason")));
                int i = 0;
                for (Map.Entry<List<ResourceLocation>, Component> channelData : mergedChannelData.entrySet()) {
                    rows.add(new Row(this.toChannelComponent(channelData.getKey(), i % 2 == 0 ? ChatFormatting.GOLD : ChatFormatting.YELLOW), channelData.getValue().copy()));
                    if (++i != 30 || mergedChannelData.size() <= 30) continue;
                    rows.add(new Row(Component.literal((String)""), Component.translatable((String)"fml.modmismatchscreen.additional", (Object[])new Object[]{mergedChannelData.size() - i}).withStyle(ChatFormatting.ITALIC)));
                    break;
                }
                rows.add(new Row(Component.literal((String)""), Component.literal((String)"")));
            }
            this.lineTable = rows.stream().flatMap(p -> this.splitLineToWidth(p.name(), p.reason()).stream()).collect(Collectors.toList());
            this.contentSize = this.lineTable.size();
            this.scrollDistance = 0.0f;
        }

        private Map<List<ResourceLocation>, Component> sortAndMergeChannelData(Map<ResourceLocation, Component> mismatchedChannelData) {
            LinkedHashMap<Component, ArrayList> channelsByReason = new LinkedHashMap<Component, ArrayList>();
            List<ResourceLocation> sortedChannels = mismatchedChannelData.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).toList();
            for (ResourceLocation channel : sortedChannels) {
                Component channelMismatchReason = mismatchedChannelData.get(channel);
                if (channelsByReason.containsKey(channelMismatchReason)) {
                    ((List)channelsByReason.get(channelMismatchReason)).add(channel);
                    continue;
                }
                channelsByReason.put(channelMismatchReason, Lists.newArrayList((Object[])new ResourceLocation[]{channel}));
            }
            LinkedHashMap<List<ResourceLocation>, Component> channelMismatchEntries = new LinkedHashMap<List<ResourceLocation>, Component>();
            List<Component> sortedChannelEntries = channelsByReason.entrySet().stream().sorted(Comparator.comparing(entry -> ((ResourceLocation)((List)entry.getValue()).get(0)).toString())).map(Map.Entry::getKey).toList();
            for (Component mismatchReason : sortedChannelEntries) {
                channelMismatchEntries.put((List)channelsByReason.get(mismatchReason), mismatchReason);
            }
            return channelMismatchEntries;
        }

        private List<Pair<FormattedCharSequence, FormattedCharSequence>> splitLineToWidth(MutableComponent name, MutableComponent reason) {
            Style style = name.getStyle();
            List nameLines = ModMismatchDisconnectedScreen.this.font.split((FormattedText)name, this.nameWidth - 4);
            List reasonLines = ModMismatchDisconnectedScreen.this.font.split((FormattedText)reason.setStyle(style), this.versionWidth - 4);
            ArrayList<Pair<FormattedCharSequence, FormattedCharSequence>> splitLines = new ArrayList<Pair<FormattedCharSequence, FormattedCharSequence>>();
            int rowsOccupied = Math.max(nameLines.size(), reasonLines.size());
            for (int i = 0; i < rowsOccupied; ++i) {
                splitLines.add((Pair<FormattedCharSequence, FormattedCharSequence>)Pair.of((Object)(i < nameLines.size() ? (FormattedCharSequence)nameLines.get(i) : FormattedCharSequence.EMPTY), (Object)(i < reasonLines.size() ? (FormattedCharSequence)reasonLines.get(i) : FormattedCharSequence.EMPTY)));
            }
            return splitLines;
        }

        private MutableComponent toChannelComponent(List<ResourceLocation> ids, ChatFormatting color) {
            MutableComponent namespaceComponent;
            if (this.oneChannelPerEntry) {
                namespaceComponent = Component.literal((String)ids.get(0).toString()).withStyle(color);
                if (ids.size() > 1) {
                    namespaceComponent.append((Component)Component.literal((String)"\n[+%s more]".formatted(ids.size() - 1)).withStyle(ChatFormatting.DARK_GRAY));
                }
            } else {
                namespaceComponent = ComponentUtils.formatList(ids, (Component)ComponentUtils.DEFAULT_SEPARATOR, r -> Component.literal((String)r.toString())).withStyle(color);
            }
            return namespaceComponent;
        }

        public void toggleSimplifiedView() {
            this.oneChannelPerEntry = !this.oneChannelPerEntry;
            this.updateListContent();
        }

        @Override
        protected int getContentHeight() {
            Objects.requireNonNull(ModMismatchDisconnectedScreen.this.font);
            int height = this.contentSize * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        @Override
        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            int i = 0;
            for (Pair<FormattedCharSequence, FormattedCharSequence> line : this.lineTable) {
                FormattedCharSequence name = (FormattedCharSequence)line.getLeft();
                FormattedCharSequence reasons = (FormattedCharSequence)line.getRight();
                int color = ARGB.opaque((int)Optional.ofNullable(ModMismatchDisconnectedScreen.this.font.getSplitter().componentStyleAtWidth(name, 0)).map(Style::getColor).map(TextColor::getValue).orElse(0xFFFFFF));
                int nameLeft = this.left + this.border + (reasons == null ? 0 : 10);
                guiGraphics.drawString(ModMismatchDisconnectedScreen.this.font, name, nameLeft, relativeY + i * 12, color, false);
                if (reasons != null) {
                    guiGraphics.drawString(ModMismatchDisconnectedScreen.this.font, reasons, this.left + this.border + 10 + this.nameWidth, relativeY + i * 12, color, false);
                }
                ++i;
            }
        }

        @Override
        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            Style style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null && style.getHoverEvent() != null) {
                guiGraphics.renderComponentHoverEffect(ModMismatchDisconnectedScreen.this.font, style, mouseX, mouseY);
            }
        }

        @Nullable
        public Style getComponentStyleAt(double x, double y) {
            double relativeX;
            double relativeY;
            int slotIndex;
            if (this.isMouseOver(x, y) && (slotIndex = (int)((relativeY = y - (double)this.top + (double)this.scrollDistance - (double)this.border) + (double)(this.border / 2)) / 12) < this.contentSize && (relativeX = x - (double)this.left - (double)this.border - (double)(this.lineTable.get(slotIndex).getRight() == null ? 0 : 10)) >= 0.0) {
                return ModMismatchDisconnectedScreen.this.font.getSplitter().componentStyleAtWidth((FormattedCharSequence)this.lineTable.get(slotIndex).getLeft(), (int)relativeX);
            }
            return null;
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            Style style = this.getComponentStyleAt(event.x(), event.y());
            if (style != null) {
                ModMismatchDisconnectedScreen.this.handleComponentClicked(style);
                return true;
            }
            return super.mouseClicked(event, doubleClick);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput output) {
        }
    }
}

