/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.classloading.transformation.ClassTransformStatistics;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.crafting.RecipePriorityManager;
import net.neoforged.neoforge.common.loot.LootModifierManager;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.internal.NeoForgeProxy;
import net.neoforged.neoforge.network.ConfigSync;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.payload.RegistryDataMapSyncPayload;
import net.neoforged.neoforge.registries.DataMapLoader;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.resource.NeoForgeReloadListeners;
import net.neoforged.neoforge.server.command.ConfigCommand;
import net.neoforged.neoforge.server.command.NeoForgeCommand;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NeoForgeEventHandler {
    private static LootModifierManager LOOT_MODIFIER_MANAGER;
    private static DataMapLoader DATA_MAP_LOADER;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity newEntity;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (entity.getClass().equals(ItemEntity.class) && (item = (stack = ((ItemEntity)entity).getItem()).getItem()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getLevel(), entity, stack)) != null) {
            MinecraftServer minecraftServer;
            entity.discard();
            event.setCanceled(true);
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                minecraftServer = serverLevel.getServer();
            } else {
                minecraftServer = NeoForgeProxy.INSTANCE.getClientExecutor();
            }
            MinecraftServer executor = minecraftServer;
            executor.schedule((Runnable)new TickTask(0, () -> event.getLevel().addFreshEntity(newEntity)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            FakePlayerFactory.unloadLevel((ServerLevel)event.getLevel());
        }
    }

    @SubscribeEvent
    public void postServerTick(ServerTickEvent.Post event) {
        ConfigSync.syncPendingConfigs(event.getServer());
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            FarmlandWaterManager.removeTickets(event.getChunk());
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.getEntity().getUUID(), event.getEntity().getGameProfile().name());
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            DATA_MAP_LOADER.apply();
        }
    }

    @SubscribeEvent
    public void onDpSync(OnDatapackSyncEvent event) {
        RegistryManager.getDataMaps().forEach((registry, values) -> {
            Optional regOpt = event.getPlayerList().getServer().overworld().registryAccess().lookup(registry);
            if (regOpt.isEmpty()) {
                return;
            }
            event.getRelevantPlayers().forEach(player -> {
                if (!player.connection.hasChannel(RegistryDataMapSyncPayload.TYPE)) {
                    return;
                }
                if (player.connection.getConnection().isMemoryConnection() && DataPackRegistriesHooks.getSyncedRegistry(registry) == null) {
                    return;
                }
                Map playerMaps = (Map)player.connection.getConnection().channel().attr(RegistryManager.ATTRIBUTE_KNOWN_DATA_MAPS).get();
                if (playerMaps == null) {
                    return;
                }
                this.handleSync((ServerPlayer)player, (Registry)((Registry)regOpt.get()), playerMaps.getOrDefault(registry, List.of()));
            });
        });
    }

    private <T> void handleSync(ServerPlayer player, Registry<T> registry, Collection<ResourceLocation> attachments) {
        if (attachments.isEmpty()) {
            return;
        }
        HashMap att = new HashMap();
        attachments.forEach(key -> {
            DataMapType attach = RegistryManager.getDataMap(registry.key(), key);
            if (attach == null || attach.networkCodec() == null) {
                return;
            }
            att.put((ResourceLocation)key, registry.getDataMap(attach));
        });
        if (!att.isEmpty()) {
            PacketDistributor.sendToPlayer(player, new RegistryDataMapSyncPayload(registry.key(), att), new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        NeoForgeCommand.register(event.getDispatcher());
        ConfigCommand.register(event.getDispatcher());
    }

    @SubscribeEvent
    public void onResourceReload(AddServerReloadListenersEvent event) {
        LOOT_MODIFIER_MANAGER = new LootModifierManager();
        event.addListener(NeoForgeReloadListeners.LOOT_MODIFIERS, (PreparableReloadListener)LOOT_MODIFIER_MANAGER);
        event.addListener(NeoForgeReloadListeners.RECIPE_PRIORITIES, (PreparableReloadListener)new RecipePriorityManager(event.getServerResources().getRecipeManager()));
        DATA_MAP_LOADER = new DataMapLoader(event.getConditionContext(), event.getRegistryAccess());
        event.addListener(NeoForgeReloadListeners.DATA_MAPS, DATA_MAP_LOADER);
        event.addListener(NeoForgeReloadListeners.CREATIVE_TABS, CreativeModeTabRegistry.getReloadListener());
    }

    static LootModifierManager getLootModifierManager() {
        if (LOOT_MODIFIER_MANAGER == null) {
            throw new IllegalStateException("Can not retrieve LootModifierManager until resources have loaded once.");
        }
        return LOOT_MODIFIER_MANAGER;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void builtinMobSpawnBlocker(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (mob = (Mob)entity).isSpawnCancelled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void logTransformationsOnGameShutdown(GameShuttingDownEvent event) {
        ClassTransformStatistics.logTransformationSummary();
        ClassTransformStatistics.checkTransformationBehavior();
    }
}

