/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.entity.animation.json;

import com.google.common.collect.MapMaker;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.neoforged.neoforge.client.entity.animation.json.AnimationHolder;
import net.neoforged.neoforge.client.entity.animation.json.AnimationParser;
import net.neoforged.neoforge.resource.ContextAwareReloadListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AnimationLoader
extends ContextAwareReloadListener
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    public static final PreparableReloadListener.StateKey<PendingAnimations> STATE_KEY = new PreparableReloadListener.StateKey();
    private static final FileToIdConverter LISTER = FileToIdConverter.json((String)"neoforge/animations/entity");
    private final Map<ResourceLocation, AnimationHolder> animations = new MapMaker().weakValues().concurrencyLevel(1).makeMap();
    private final List<AnimationHolder> strongHolderReferences = new ArrayList<AnimationHolder>();

    private AnimationLoader() {
    }

    @Nullable
    public AnimationDefinition getAnimation(ResourceLocation key) {
        AnimationHolder holder = this.animations.get(key);
        return holder != null ? holder.getOrNull() : null;
    }

    public AnimationHolder getAnimationHolder(ResourceLocation key) {
        return this.animations.computeIfAbsent(key, AnimationHolder::new);
    }

    public void prepareSharedState(PreparableReloadListener.SharedState sharedState) {
        sharedState.set(STATE_KEY, (Object)new PendingAnimations());
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.SharedState sharedState, Executor prepareExecutor, PreparableReloadListener.PreparationBarrier barrier, Executor applyExecutor) {
        ResourceManager resourceManager = sharedState.resourceManager();
        PendingAnimations pending = (PendingAnimations)sharedState.get(STATE_KEY);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(resourceManager), prepareExecutor).whenComplete((map, error) -> {
            if (map != null) {
                pending.future.complete((Map<ResourceLocation, AnimationDefinition>)map);
            } else {
                pending.future.completeExceptionally((Throwable)error);
            }
        })).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(this::apply, applyExecutor);
    }

    private Map<ResourceLocation, AnimationDefinition> prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, AnimationDefinition> map = new HashMap<ResourceLocation, AnimationDefinition>();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (FileToIdConverter)LISTER, this.makeConditionalOps((DynamicOps<JsonElement>)JsonOps.INSTANCE), AnimationParser.CODEC, map);
        return map;
    }

    private void apply(Map<ResourceLocation, AnimationDefinition> animationJsons) {
        this.animations.values().forEach(AnimationHolder::unbind);
        this.strongHolderReferences.clear();
        int loaded = 0;
        for (Map.Entry<ResourceLocation, AnimationDefinition> entry : animationJsons.entrySet()) {
            AnimationHolder holder = this.getAnimationHolder(entry.getKey());
            holder.bind(entry.getValue());
            this.strongHolderReferences.add(holder);
            ++loaded;
        }
        LOGGER.info("Loaded {} entity animations", (Object)loaded);
    }

    public static final class PendingAnimations {
        public static final PendingAnimations EMPTY = (PendingAnimations)Util.make((Object)new PendingAnimations(), pending -> pending.future.complete(Map.of()));
        private final CompletableFuture<Map<ResourceLocation, AnimationDefinition>> future = new CompletableFuture();

        private PendingAnimations() {
        }

        @Nullable
        public AnimationDefinition get(ResourceLocation id) {
            return this.future.join().get(id);
        }
    }
}

