/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.NeoForgeRenderPipelines;
import net.neoforged.neoforge.common.util.Lazy;

public enum NeoForgeRenderTypes {
    ITEM_LAYERED_SOLID(() -> NeoForgeRenderTypes.getItemLayeredSolid(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_LAYERED_CUTOUT(() -> NeoForgeRenderTypes.getItemLayeredCutout(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_LAYERED_CUTOUT_MIPPED(() -> NeoForgeRenderTypes.getItemLayeredCutoutMipped(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_LAYERED_TRANSLUCENT(() -> NeoForgeRenderTypes.getItemLayeredTranslucent(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_UNSORTED_TRANSLUCENT(() -> NeoForgeRenderTypes.getUnsortedTranslucent(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_UNLIT_TRANSLUCENT(() -> NeoForgeRenderTypes.getUnlitTranslucent(TextureAtlas.LOCATION_BLOCKS)),
    ITEM_UNSORTED_UNLIT_TRANSLUCENT(() -> NeoForgeRenderTypes.getUnlitTranslucent(TextureAtlas.LOCATION_BLOCKS, false));

    private final Supplier<RenderType> renderTypeSupplier;

    public static RenderType getItemLayeredSolid(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_SOLID.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutout(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutoutMipped(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getItemLayeredTranslucent(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnsortedTranslucent(ResourceLocation textureLocation) {
        return Internal.UNSORTED_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation) {
        return Internal.UNLIT_TRANSLUCENT_SORTED.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation, boolean sortingEnabled) {
        return (sortingEnabled ? Internal.UNLIT_TRANSLUCENT_SORTED : Internal.UNLIT_TRANSLUCENT_UNSORTED).apply(textureLocation);
    }

    public static RenderType getEntityCutoutMipped(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getTextFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_FILTERED.apply(locationIn);
    }

    public static RenderType getTextIntensityFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY_FILTERED.apply(locationIn);
    }

    public static RenderType getTextPolygonOffsetFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_POLYGON_OFFSET_FILTERED.apply(locationIn);
    }

    public static RenderType getTextIntensityPolygonOffsetFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY_POLYGON_OFFSET_FILTERED.apply(locationIn);
    }

    public static RenderType getTextSeeThroughFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_SEETHROUGH_FILTERED.apply(locationIn);
    }

    public static RenderType getTextIntensitySeeThroughFiltered(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY_SEETHROUGH_FILTERED.apply(locationIn);
    }

    private NeoForgeRenderTypes(Supplier<RenderType> renderTypeSupplier) {
        this.renderTypeSupplier = Lazy.of(renderTypeSupplier);
    }

    public RenderType get() {
        return this.renderTypeSupplier.get();
    }

    private static final class Internal {
        public static Function<ResourceLocation, RenderType> UNSORTED_TRANSLUCENT = Util.memoize(Internal::unsortedTranslucent);
        public static Function<ResourceLocation, RenderType> UNLIT_TRANSLUCENT_SORTED = Util.memoize(tex -> Internal.unlitTranslucent(tex, true));
        public static Function<ResourceLocation, RenderType> UNLIT_TRANSLUCENT_UNSORTED = Util.memoize(tex -> Internal.unlitTranslucent(tex, false));
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_SOLID = Util.memoize(Internal::layeredItemSolid);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_CUTOUT = Util.memoize(Internal::layeredItemCutout);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_CUTOUT_MIPPED = Util.memoize(Internal::layeredItemCutoutMipped);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_TRANSLUCENT = Util.memoize(Internal::layeredItemTranslucent);
        public static Function<ResourceLocation, RenderType> TEXT_FILTERED = Util.memoize(Internal::getTextFiltered);
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_FILTERED = Util.memoize(Internal::getTextIntensityFiltered);
        public static Function<ResourceLocation, RenderType> TEXT_POLYGON_OFFSET_FILTERED = Util.memoize(Internal::getTextPolygonOffsetFiltered);
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_POLYGON_OFFSET_FILTERED = Util.memoize(Internal::getTextIntensityPolygonOffsetFiltered);
        public static Function<ResourceLocation, RenderType> TEXT_SEETHROUGH_FILTERED = Util.memoize(Internal::getTextSeeThroughFiltered);
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_SEETHROUGH_FILTERED = Util.memoize(Internal::getTextIntensitySeeThroughFiltered);

        private Internal() {
        }

        private static RenderType unsortedTranslucent(ResourceLocation textureLocation) {
            boolean sortingEnabled = false;
            RenderType.CompositeState renderState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_entity_unsorted_translucent", (int)256, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT, (RenderType.CompositeState)renderState);
        }

        private static RenderType unlitTranslucent(ResourceLocation textureLocation, boolean sortingEnabled) {
            RenderType.CompositeState renderState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_entity_unlit_translucent", (int)256, (boolean)true, (boolean)sortingEnabled, (RenderPipeline)NeoForgeRenderPipelines.ENTITY_UNLIT_TRANSLUCENT, (RenderType.CompositeState)renderState);
        }

        private static RenderType layeredItemSolid(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_item_entity_solid", (int)256, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_SOLID, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType layeredItemCutout(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_item_entity_cutout", (int)256, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_CUTOUT, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType layeredItemCutoutMipped(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, true)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_item_entity_cutout_mipped", (int)256, (boolean)true, (boolean)false, (RenderPipeline)NeoForgeRenderPipelines.ENTITY_SMOOTH_CUTOUT_CULL, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType layeredItemTranslucent(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
            return RenderType.create((String)"neoforge_item_entity_translucent_cull", (int)256, (boolean)true, (boolean)true, (RenderPipeline)NeoForgeRenderPipelines.ENTITY_TRANSLUCENT_CULL, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextIntensityFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text_intensity", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_INTENSITY, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextPolygonOffsetFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text_polygon_offset", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_POLYGON_OFFSET, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextIntensityPolygonOffsetFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text_intensity_polygon_offset", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_INTENSITY, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextSeeThroughFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text_see_through", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_SEE_THROUGH, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType getTextIntensitySeeThroughFiltered(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setTexturingState((RenderStateShard.TexturingStateShard)new LinearFilteredTexturing(locationIn)).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false);
            return RenderType.create((String)"neoforge_text_intensity_see_through", (int)256, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_INTENSITY_SEE_THROUGH, (RenderType.CompositeState)rendertype$state);
        }

        private static final class LinearFilteredTexturing
        extends RenderStateShard.TexturingStateShard {
            public LinearFilteredTexturing(ResourceLocation textureLoc) {
                super("neoforge:linear_filtered", () -> {
                    TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                    AbstractTexture texture = texturemanager.getTexture(textureLoc);
                    texture.setFilter(true, false);
                }, () -> {
                    TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                    AbstractTexture texture = texturemanager.getTexture(textureLoc);
                    texture.setFilter(false, false);
                });
            }
        }
    }
}

