/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer;

import java.util.Objects;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class ItemAccessResourceHandler<T extends Resource>
implements ResourceHandler<T> {
    protected final ItemAccess itemAccess;
    protected final int size;

    protected ItemAccessResourceHandler(ItemAccess itemAccess, int size) {
        this.itemAccess = itemAccess;
        this.size = size;
    }

    protected abstract T getResourceFrom(ItemResource var1, int var2);

    protected abstract int getAmountFrom(ItemResource var1, int var2);

    protected abstract ItemResource update(ItemResource var1, int var2, T var3, int var4);

    @Override
    public boolean isValid(int index, T resource) {
        return true;
    }

    protected abstract int getCapacity(int var1, T var2);

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T getResource(int index) {
        Objects.checkIndex(index, this.size());
        return this.getResourceFrom(this.itemAccess.getResource(), index);
    }

    @Override
    public long getAmountAsLong(int index) {
        Objects.checkIndex(index, this.size());
        return (long)this.itemAccess.getAmount() * (long)this.getAmountFrom(this.itemAccess.getResource(), index);
    }

    @Override
    public long getCapacityAsLong(int index, T resource) {
        Objects.checkIndex(index, this.size());
        if (resource.isEmpty() || this.isValid(index, resource)) {
            return (long)this.itemAccess.getAmount() * (long)this.getCapacity(index, resource);
        }
        return 0L;
    }

    @Override
    public int insert(int index, T resource, int amount, TransactionContext transaction) {
        ItemResource filledResource;
        int insertedPerItem;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        int amountPerItem = amount / accessAmount;
        ItemResource accessResource = this.itemAccess.getResource();
        int currentAmountPerItem = this.getAmountFrom(accessResource, index);
        if ((currentAmountPerItem == 0 || resource.equals(this.getResourceFrom(accessResource, index))) && this.isValid(index, resource) && (insertedPerItem = Math.min(amountPerItem, this.getCapacity(index, resource) - currentAmountPerItem)) > 0 && !(filledResource = this.update(accessResource, index, resource, insertedPerItem + currentAmountPerItem)).isEmpty()) {
            return insertedPerItem * this.itemAccess.exchange(filledResource, accessAmount, transaction);
        }
        return 0;
    }

    @Override
    public int extract(int index, T resource, int amount, TransactionContext transaction) {
        ItemResource emptiedResource;
        int currentAmountPerItem;
        int extractedPerItem;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        ItemResource accessResource = this.itemAccess.getResource();
        T currentResource = this.getResourceFrom(accessResource, index);
        if (resource.equals(currentResource) && (extractedPerItem = Math.min(amount / accessAmount, currentAmountPerItem = this.getAmountFrom(accessResource, index))) > 0 && !(emptiedResource = this.update(accessResource, index, resource, currentAmountPerItem - extractedPerItem)).isEmpty()) {
            return extractedPerItem * this.itemAccess.exchange(emptiedResource, accessAmount, transaction);
        }
        return 0;
    }
}

