/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LevelAttachmentsSavedData
extends SavedData {
    public static final SavedDataType<LevelAttachmentsSavedData> TYPE = new SavedDataType("neoforge_data_attachments", LevelAttachmentsSavedData::new, LevelAttachmentsSavedData::makeCodec);
    private final ServerLevel level;

    public static void init(ServerLevel level) {
        level.getDataStorage().computeIfAbsent(TYPE);
    }

    private static Codec<LevelAttachmentsSavedData> makeCodec(SavedData.Context context) {
        return CompoundTag.CODEC.flatXmap(tag -> {
            LevelAttachmentsSavedData data = new LevelAttachmentsSavedData(context);
            ProblemReporter.Collector reporter = new ProblemReporter.Collector();
            data.level.deserializeAttachments(TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)data.level.registryAccess(), (CompoundTag)tag));
            return !reporter.isEmpty() ? DataResult.error(() -> "Deserialisation error in level attachments: " + reporter.getReport()) : DataResult.success((Object)((Object)data));
        }, data -> {
            ProblemReporter.Collector reporter = new ProblemReporter.Collector();
            TagValueOutput tag = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)data.level.registryAccess());
            data.level.serializeAttachments((ValueOutput)tag);
            return !reporter.isEmpty() ? DataResult.error(() -> "Serialisation error in level attachments: " + reporter.getReport()) : DataResult.success((Object)tag.buildResult());
        });
    }

    public LevelAttachmentsSavedData(SavedData.Context context) {
        this.level = context.levelOrThrow();
    }

    public boolean isDirty() {
        return true;
    }
}

