/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

public final class RenderTypeHelper {
    public static RenderType getEntityRenderType(ChunkSectionLayer chunkSectionLayer) {
        if (chunkSectionLayer != ChunkSectionLayer.TRANSLUCENT) {
            return Sheets.cutoutBlockSheet();
        }
        return Sheets.translucentItemSheet();
    }

    public static RenderType getMovingBlockRenderType(ChunkSectionLayer chunkSectionLayer) {
        return switch (chunkSectionLayer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> RenderType.solid();
            case ChunkSectionLayer.CUTOUT_MIPPED -> RenderType.cutoutMipped();
            case ChunkSectionLayer.CUTOUT -> RenderType.cutout();
            case ChunkSectionLayer.TRANSLUCENT -> RenderType.translucentMovingBlock();
            case ChunkSectionLayer.TRIPWIRE -> RenderType.tripwire();
        };
    }

    private RenderTypeHelper() {
    }
}

