/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.codec;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.connection.ConnectionType;

public final class NeoForgeStreamCodecs {
    public static final StreamCodec<FriendlyByteBuf, byte[]> UNBOUNDED_BYTE_ARRAY = new StreamCodec<FriendlyByteBuf, byte[]>(){

        public byte[] decode(FriendlyByteBuf buf) {
            return buf.readByteArray();
        }

        public void encode(FriendlyByteBuf buf, byte[] data) {
            buf.writeByteArray(data);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, ChunkPos> CHUNK_POS = new StreamCodec<FriendlyByteBuf, ChunkPos>(){

        public ChunkPos decode(FriendlyByteBuf buf) {
            return buf.readChunkPos();
        }

        public void encode(FriendlyByteBuf buf, ChunkPos pos) {
            buf.writeChunkPos(pos);
        }
    };

    public static <B, V> StreamCodec<B, V> lazy(Supplier<StreamCodec<B, V>> streamCodecSupplier) {
        return new LazyStreamCodec<B, V>(streamCodecSupplier);
    }

    public static <B extends FriendlyByteBuf, V extends Enum<V>> StreamCodec<B, V> enumCodec(final Class<V> enumClass) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                return buf.readEnum(enumClass);
            }

            public void encode(B buf, V value) {
                buf.writeEnum(value);
            }
        };
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, ResourceKey<? extends Registry<?>>> registryKey() {
        return new StreamCodec<B, ResourceKey<? extends Registry<?>>>(){

            public ResourceKey<? extends Registry<?>> decode(B buf) {
                return ResourceKey.createRegistryKey((ResourceLocation)buf.readResourceLocation());
            }

            public void encode(B buf, ResourceKey<? extends Registry<?>> value) {
                buf.writeResourceLocation(value.location());
            }
        };
    }

    public static <V> StreamCodec<RegistryFriendlyByteBuf, V> connectionAware(final StreamCodec<? super RegistryFriendlyByteBuf, V> neoForgeCodec, final StreamCodec<? super RegistryFriendlyByteBuf, V> otherCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, V>(){

            public V decode(RegistryFriendlyByteBuf buf) {
                return switch (buf.getConnectionType()) {
                    default -> throw new MatchException(null, null);
                    case ConnectionType.NEOFORGE -> neoForgeCodec.decode((Object)buf);
                    case ConnectionType.OTHER -> otherCodec.decode((Object)buf);
                };
            }

            public void encode(RegistryFriendlyByteBuf buf, V value) {
                switch (buf.getConnectionType()) {
                    case NEOFORGE: {
                        neoForgeCodec.encode((Object)buf, value);
                        break;
                    }
                    case OTHER: {
                        otherCodec.encode((Object)buf, value);
                    }
                }
            }
        };
    }

    public static <B, V> StreamCodec<B, V> uncheckedUnit(final V defaultValue) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                return defaultValue;
            }

            public void encode(B buf, V value) {
            }
        };
    }

    private static class LazyStreamCodec<B, V>
    implements StreamCodec<B, V> {
        private final Lazy<StreamCodec<B, V>> delegate;

        public LazyStreamCodec(Supplier<StreamCodec<B, V>> streamCodecSupplier) {
            this.delegate = Lazy.of(streamCodecSupplier);
        }

        public void encode(B buf, V value) {
            this.delegate.get().encode(buf, value);
        }

        public V decode(B buf) {
            return (V)this.delegate.get().decode(buf);
        }
    }
}

