/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.handling;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerPlayerConnection;
import net.neoforged.neoforge.common.extensions.IServerConfigurationPacketListenerExtension;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ServerPayloadContext
extends Record
implements IPayloadContext {
    private final ServerCommonPacketListener listener;
    private final ResourceLocation payloadId;

    public ServerPayloadContext(ServerCommonPacketListener listener, ResourceLocation payloadId) {
        this.listener = listener;
        this.payloadId = payloadId;
    }

    @Override
    public void handle(CustomPacketPayload payload) {
        this.handle((Packet<?>)new ServerboundCustomPayloadPacket(payload));
    }

    @Override
    public CompletableFuture<Void> enqueueWork(Runnable task) {
        PacketProcessor processor = this.listener.getPacketProcessor();
        if (processor.isSameThread()) {
            task.run();
            return CompletableFuture.completedFuture(null);
        }
        return NetworkRegistry.guard(CompletableFuture.runAsync(task, arg_0 -> ((PacketProcessor)processor).scheduleIfPossible(arg_0)), this.payloadId);
    }

    @Override
    public <T> CompletableFuture<T> enqueueWork(Supplier<T> task) {
        PacketProcessor processor = this.listener.getPacketProcessor();
        if (processor.isSameThread()) {
            return CompletableFuture.completedFuture(task.get());
        }
        return NetworkRegistry.guard(CompletableFuture.supplyAsync(task, arg_0 -> ((PacketProcessor)processor).scheduleIfPossible(arg_0)), this.payloadId);
    }

    @Override
    public void finishCurrentTask(ConfigurationTask.Type type) {
        ServerCommonPacketListener serverCommonPacketListener = this.listener;
        if (!(serverCommonPacketListener instanceof IServerConfigurationPacketListenerExtension)) {
            throw new UnsupportedOperationException("Attempted to complete a configuration task outside of the configuration phase!");
        }
        IServerConfigurationPacketListenerExtension ext = (IServerConfigurationPacketListenerExtension)serverCommonPacketListener;
        ext.finishCurrentTask(type);
    }

    @Override
    public PacketFlow flow() {
        return PacketFlow.SERVERBOUND;
    }

    public ServerPlayer player() {
        ServerCommonPacketListener serverCommonPacketListener = this.listener;
        if (serverCommonPacketListener instanceof ServerPlayerConnection) {
            ServerPlayerConnection spc = (ServerPlayerConnection)serverCommonPacketListener;
            return spc.getPlayer();
        }
        throw new UnsupportedOperationException("Cannot retrieve the sending player during the configuration phase.");
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerPayloadContext.class, "listener;payloadId", "listener", "payloadId"}, this, o);
    }

    public ServerCommonPacketListener listener() {
        return this.listener;
    }

    public ResourceLocation payloadId() {
        return this.payloadId;
    }
}

