/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.entity.animation.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.client.entity.animation.AnimationKeyframeTarget;
import net.neoforged.neoforge.client.entity.animation.AnimationTarget;
import net.neoforged.neoforge.client.entity.animation.json.AnimationTypeManager;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class AnimationParser {
    private static final Codec<AnimationTarget> TARGET_CODEC = ResourceLocation.CODEC.flatXmap(name -> Optional.ofNullable(AnimationTypeManager.getTarget(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Animation target '%s' not found. Registered targets: %s", name, AnimationTypeManager.getTargetList()))), target -> Optional.ofNullable(AnimationTypeManager.getTargetName(target)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation target '%s'. Registered targets: %s", target, AnimationTypeManager.getTargetList()))));
    private static final Codec<AnimationChannel.Interpolation> INTERPOLATION_CODEC = ResourceLocation.CODEC.flatXmap(name -> Optional.ofNullable(AnimationTypeManager.getInterpolation(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Animation interpolation '%s' not found. Registered interpolations: %s", name, AnimationTypeManager.getInterpolationList()))), target -> Optional.ofNullable(AnimationTypeManager.getInterpolationName(target)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation interpolation '%s'. Registered interpolations: %s", target, AnimationTypeManager.getInterpolationList()))));
    public static final MapCodec<AnimationChannel> CHANNEL_CODEC = new KeyDispatchCodec("target", TARGET_CODEC, channel -> Optional.ofNullable(AnimationTypeManager.getTargetFromChannelTarget(channel.target())).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation channel target '%s'. Registered targets: %s", channel.target(), AnimationTypeManager.getTargetList()))), target -> DataResult.success((Object)Optional.ofNullable(AnimationTypeManager.getKeyframeCodec(target)).orElseGet(() -> AnimationParser.keyframeCodec(target)).listOf().xmap(keyframes -> new AnimationChannel(target.channelTarget(), (Keyframe[])keyframes.toArray(Keyframe[]::new)), channel -> Arrays.asList(channel.keyframes())).fieldOf("keyframes")));
    private static final Codec<Pair<String, AnimationChannel>> NAMED_CHANNEL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("bone").forGetter(Pair::getFirst), (App)CHANNEL_CODEC.forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final Codec<AnimationDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("length").forGetter(AnimationDefinition::lengthInSeconds), (App)Codec.BOOL.optionalFieldOf("loop", (Object)false).forGetter(AnimationDefinition::looping), (App)NAMED_CHANNEL_CODEC.listOf().xmap(list -> {
        HashMap<String, List> result = new HashMap<String, List>();
        for (Pair animation : list) {
            result.computeIfAbsent((String)animation.getFirst(), k -> new ArrayList()).add((AnimationChannel)animation.getSecond());
        }
        return result;
    }, map -> {
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (Map.Entry entry : map.entrySet()) {
            for (AnimationChannel channel : (List)entry.getValue()) {
                result.add(Pair.of((Object)((String)entry.getKey()), (Object)channel));
            }
        }
        return result;
    }).fieldOf("animations").forGetter(AnimationDefinition::boneAnimations)).apply((Applicative)instance, AnimationDefinition::new));

    private AnimationParser() {
    }

    static Codec<Keyframe> keyframeCodec(AnimationTarget target) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("timestamp").forGetter(Keyframe::timestamp), (App)Codec.mapEither((MapCodec)Codec.mapPair((MapCodec)AnimationParser.targetCodec(target).fieldOf("preTarget"), (MapCodec)AnimationParser.targetCodec(target).fieldOf("postTarget")), (MapCodec)AnimationParser.targetCodec(target).fieldOf("target")).forGetter(keyframe -> {
            if (keyframe.preTarget().equals((Object)keyframe.postTarget())) {
                return Either.right((Object)keyframe.preTarget());
            }
            return Either.left((Object)Pair.of((Object)keyframe.preTarget(), (Object)keyframe.postTarget()));
        }), (App)INTERPOLATION_CODEC.fieldOf("interpolation").forGetter(Keyframe::interpolation)).apply((Applicative)instance, AnimationParser::constructKeyframe));
    }

    private static Codec<Vector3fc> targetCodec(AnimationTarget target) {
        return ExtraCodecs.VECTOR3F.xmap(vec -> vec, vec -> {
            Vector3f vector3f;
            return vec instanceof Vector3f ? (vector3f = (Vector3f)vec) : new Vector3f(vec);
        }).xmap(AnimationParser.keyframeTargetToUnaryOp(target.keyframeTarget()), AnimationParser.keyframeTargetToUnaryOp(target.inverseKeyframeTarget()));
    }

    private static Keyframe constructKeyframe(float timestamp, Either<Pair<Vector3fc, Vector3fc>, Vector3fc> target, AnimationChannel.Interpolation interpolation) {
        Vector3fc preTarget = (Vector3fc)target.map(Pair::getFirst, Function.identity());
        Vector3fc postTarget = (Vector3fc)target.map(Pair::getSecond, Function.identity());
        return new Keyframe(timestamp, preTarget, postTarget, interpolation);
    }

    private static UnaryOperator<Vector3fc> keyframeTargetToUnaryOp(AnimationKeyframeTarget target) {
        return vec -> target.apply(vec.x(), vec.y(), vec.z());
    }
}

